/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.generation.rules;

import com.phoenixnap.oss.ramlapisync.data.ApiActionMetadata;
import com.phoenixnap.oss.ramlapisync.data.ApiResourceMetadata;
import com.phoenixnap.oss.ramlapisync.generation.CodeModelHelper;
import com.phoenixnap.oss.ramlapisync.generation.rules.Rule;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class GenericJavaClassRule
implements Rule<JCodeModel, JDefinedClass, ApiResourceMetadata> {
    private Rule<JCodeModel, JPackage, ApiResourceMetadata> packageRule;
    private Optional<Rule<JDefinedClass, JDocComment, ApiResourceMetadata>> classCommentRule = Optional.empty();
    private List<Rule<JDefinedClass, JAnnotationUse, ApiResourceMetadata>> classAnnotationRules = new ArrayList<Rule<JDefinedClass, JAnnotationUse, ApiResourceMetadata>>();
    private Rule<JPackage, JDefinedClass, ApiResourceMetadata> classRule;
    private Optional<Rule<JDefinedClass, JDefinedClass, ApiResourceMetadata>> implementsExtendsRule = Optional.empty();
    private List<Rule<JDefinedClass, JFieldVar, ApiResourceMetadata>> fieldDeclerationRules = new ArrayList<Rule<JDefinedClass, JFieldVar, ApiResourceMetadata>>();
    private Optional<Rule<JMethod, JDocComment, ApiActionMetadata>> methodCommentRule = Optional.empty();
    private List<Rule<JMethod, JAnnotationUse, ApiActionMetadata>> methodAnnotationRules = new ArrayList<Rule<JMethod, JAnnotationUse, ApiActionMetadata>>();
    private Rule<JDefinedClass, JMethod, ApiActionMetadata> methodSignatureRule;
    private Optional<Rule<CodeModelHelper.JExtMethod, JMethod, ApiActionMetadata>> methodBodyRule = Optional.empty();

    @Override
    public JDefinedClass apply(ApiResourceMetadata metadata, JCodeModel codeModel) {
        if (this.packageRule == null || this.classRule == null) {
            throw new IllegalStateException("A packageRule and classRule are mandatory.");
        }
        if (!metadata.getApiCalls().isEmpty() && this.methodSignatureRule == null) {
            throw new IllegalStateException("Since there are API Calls in the metadata at least a methodSignatureRule is mandatory");
        }
        JPackage jPackage = this.packageRule.apply(metadata, codeModel);
        JDefinedClass jClass = this.classRule.apply(metadata, jPackage);
        this.implementsExtendsRule.ifPresent(rule -> {
            JDefinedClass cfr_ignored_0 = (JDefinedClass)rule.apply(metadata, jClass);
        });
        this.classCommentRule.ifPresent(rule -> {
            JDocComment cfr_ignored_0 = (JDocComment)rule.apply(metadata, jClass);
        });
        this.classAnnotationRules.forEach(rule -> {
            JAnnotationUse cfr_ignored_0 = (JAnnotationUse)rule.apply(metadata, jClass);
        });
        this.fieldDeclerationRules.forEach(rule -> {
            JFieldVar cfr_ignored_0 = (JFieldVar)rule.apply(metadata, jClass);
        });
        metadata.getApiCalls().forEach(apiMappingMetadata -> {
            JMethod jMethod = this.methodSignatureRule.apply((ApiActionMetadata)apiMappingMetadata, jClass);
            this.methodCommentRule.ifPresent(rule -> {
                JDocComment cfr_ignored_0 = (JDocComment)rule.apply(apiMappingMetadata, jMethod);
            });
            this.methodAnnotationRules.forEach(rule -> {
                JAnnotationUse cfr_ignored_0 = (JAnnotationUse)rule.apply(apiMappingMetadata, jMethod);
            });
            this.methodBodyRule.ifPresent(rule -> {
                JMethod cfr_ignored_0 = (JMethod)rule.apply(apiMappingMetadata, CodeModelHelper.ext(jMethod, jClass.owner()));
            });
        });
        return jClass;
    }

    public GenericJavaClassRule setPackageRule(Rule<JCodeModel, JPackage, ApiResourceMetadata> packageRule) {
        this.packageRule = packageRule;
        return this;
    }

    public GenericJavaClassRule addClassAnnotationRule(Rule<JDefinedClass, JAnnotationUse, ApiResourceMetadata> annotationRule) {
        if (annotationRule != null) {
            this.classAnnotationRules.add(annotationRule);
        }
        return this;
    }

    public GenericJavaClassRule setClassCommentRule(Rule<JDefinedClass, JDocComment, ApiResourceMetadata> classCommentRule) {
        this.classCommentRule = Optional.ofNullable(classCommentRule);
        return this;
    }

    public GenericJavaClassRule setClassRule(Rule<JPackage, JDefinedClass, ApiResourceMetadata> classRule) {
        this.classRule = classRule;
        return this;
    }

    public GenericJavaClassRule setMethodSignatureRule(Rule<JDefinedClass, JMethod, ApiActionMetadata> methodSignatureRule) {
        this.methodSignatureRule = methodSignatureRule;
        return this;
    }

    public GenericJavaClassRule setMethodBodyRule(Rule<CodeModelHelper.JExtMethod, JMethod, ApiActionMetadata> methodBodyRule) {
        this.methodBodyRule = Optional.ofNullable(methodBodyRule);
        return this;
    }

    public GenericJavaClassRule addFieldDeclarationRule(Rule<JDefinedClass, JFieldVar, ApiResourceMetadata> fieldDeclerationRule) {
        this.fieldDeclerationRules.add(fieldDeclerationRule);
        return this;
    }

    public GenericJavaClassRule setImplementsExtendsRule(Rule<JDefinedClass, JDefinedClass, ApiResourceMetadata> implementsExtendsRule) {
        this.implementsExtendsRule = Optional.ofNullable(implementsExtendsRule);
        return this;
    }

    public GenericJavaClassRule addMethodAnnotationRule(Rule<JMethod, JAnnotationUse, ApiActionMetadata> methodAnnotationRule) {
        if (methodAnnotationRule != null) {
            this.methodAnnotationRules.add(methodAnnotationRule);
        }
        return this;
    }

    public GenericJavaClassRule setMethodCommentRule(Rule<JMethod, JDocComment, ApiActionMetadata> methodCommentRule) {
        this.methodCommentRule = Optional.ofNullable(methodCommentRule);
        return this;
    }
}

