/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.generation.rules;

import com.phoenixnap.oss.ramlapisync.data.ApiResourceMetadata;
import com.phoenixnap.oss.ramlapisync.generation.rules.ConfigurableRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.GenericJavaClassRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.ClassAnnotationRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.ClassCommentRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.ClassFieldDeclarationRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.ClientInterfaceDeclarationRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.ControllerMethodSignatureRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.ImplementsControllerInterfaceRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.MethodCommentRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.MethodParamsRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.PackageRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.ResourceClassDeclarationRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.spring.SpringResponseEntityRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.spring.SpringRestClientMethodBodyRule;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import java.util.Map;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

public class Spring4RestTemplateClientRule
implements ConfigurableRule<JCodeModel, JDefinedClass, ApiResourceMetadata> {
    String restTemplateFieldName = "restTemplate";
    String baseUrlFieldName = "baseUrl";
    String baseUrlConfigurationPath = "${client.url}";
    String restTemplateQualifierBeanName;

    @Override
    public final JDefinedClass apply(ApiResourceMetadata metadata, JCodeModel generatableType) {
        JDefinedClass generatedInterface = new GenericJavaClassRule().setPackageRule(new PackageRule()).setClassCommentRule(new ClassCommentRule()).setClassRule(new ClientInterfaceDeclarationRule()).setMethodCommentRule(new MethodCommentRule()).setMethodSignatureRule(new ControllerMethodSignatureRule(new SpringResponseEntityRule(), new MethodParamsRule(true))).apply(metadata, generatableType);
        GenericJavaClassRule clientGenerator = new GenericJavaClassRule().setPackageRule(new PackageRule()).setClassCommentRule(new ClassCommentRule()).addClassAnnotationRule(new ClassAnnotationRule(Component.class)).setClassRule(new ResourceClassDeclarationRule("ClientImpl")).setImplementsExtendsRule(new ImplementsControllerInterfaceRule(generatedInterface)).addFieldDeclarationRule(new ClassFieldDeclarationRule(this.restTemplateFieldName, RestTemplate.class, true, this.restTemplateQualifierBeanName)).addFieldDeclarationRule(new ClassFieldDeclarationRule(this.baseUrlFieldName, String.class, this.getBaseUrlConfigurationName())).setMethodCommentRule(new MethodCommentRule()).setMethodSignatureRule(new ControllerMethodSignatureRule(new SpringResponseEntityRule(), new MethodParamsRule())).setMethodBodyRule(new SpringRestClientMethodBodyRule(this.restTemplateFieldName, this.baseUrlFieldName));
        return clientGenerator.apply(metadata, generatableType);
    }

    private String getBaseUrlConfigurationName() {
        if (!this.baseUrlConfigurationPath.startsWith("${")) {
            this.baseUrlConfigurationPath = "${" + this.baseUrlConfigurationPath;
        }
        if (!this.baseUrlConfigurationPath.endsWith("}")) {
            this.baseUrlConfigurationPath = this.baseUrlConfigurationPath + "}";
        }
        return this.baseUrlConfigurationPath;
    }

    @Override
    public void applyConfiguration(Map<String, String> configuration) {
        if (!CollectionUtils.isEmpty(configuration)) {
            if (configuration.containsKey("restTemplateFieldName")) {
                this.restTemplateFieldName = configuration.get("restTemplateFieldName");
            }
            if (configuration.containsKey("restTemplateQualifierBeanName")) {
                this.restTemplateQualifierBeanName = configuration.get("restTemplateQualifierBeanName");
            }
            if (configuration.containsKey("baseUrlConfigurationPath")) {
                this.baseUrlConfigurationPath = configuration.get("baseUrlConfigurationPath");
            }
        }
    }
}

