/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.generation.rules.basic;

import com.phoenixnap.oss.ramlapisync.data.ApiActionMetadata;
import com.phoenixnap.oss.ramlapisync.data.ApiParameterMetadata;
import com.phoenixnap.oss.ramlapisync.generation.CodeModelHelper;
import com.phoenixnap.oss.ramlapisync.generation.rules.Rule;
import com.phoenixnap.oss.ramlapisync.naming.NamingHelper;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;

public class MethodParamsRule
implements Rule<CodeModelHelper.JExtMethod, JMethod, ApiActionMetadata> {
    boolean addParameterJavadoc = false;

    public MethodParamsRule() {
        this(false);
    }

    public MethodParamsRule(boolean addParameterJavadoc) {
        this.addParameterJavadoc = addParameterJavadoc;
    }

    @Override
    public JMethod apply(ApiActionMetadata endpointMetadata, CodeModelHelper.JExtMethod generatableType) {
        ArrayList<ApiParameterMetadata> parameterMetadataList = new ArrayList<ApiParameterMetadata>();
        parameterMetadataList.addAll(endpointMetadata.getPathVariables());
        parameterMetadataList.addAll(endpointMetadata.getRequestParameters());
        parameterMetadataList.addAll(endpointMetadata.getRequestHeaders());
        parameterMetadataList.forEach(paramMetaData -> this.param((ApiParameterMetadata)paramMetaData, generatableType));
        if (endpointMetadata.getRequestBody() != null) {
            this.param(endpointMetadata, generatableType);
        }
        if (endpointMetadata.getInjectHttpHeadersParameter()) {
            this.paramHttpHeaders(generatableType);
        }
        return generatableType.get();
    }

    protected JVar param(ApiParameterMetadata paramMetaData, CodeModelHelper.JExtMethod generatableType) {
        String javaName = NamingHelper.getParameterName(paramMetaData.getName());
        if (this.addParameterJavadoc) {
            String paramComment = "";
            if (paramMetaData.getRamlParam() != null && StringUtils.hasText((String)paramMetaData.getRamlParam().getDescription())) {
                paramComment = NamingHelper.cleanForJavadoc(paramMetaData.getRamlParam().getDescription());
            }
            generatableType.get().javadoc().addParam(javaName + " " + paramComment);
        }
        return generatableType.get().param(paramMetaData.getType(), javaName);
    }

    protected JVar param(ApiActionMetadata endpointMetadata, CodeModelHelper.JExtMethod generatableType) {
        String requestBodyName = endpointMetadata.getRequestBody().getName();
        ArrayList<JCodeModel> codeModels = new ArrayList<JCodeModel>();
        if (endpointMetadata.getRequestBody().getCodeModel() != null) {
            codeModels.add(endpointMetadata.getRequestBody().getCodeModel());
        }
        if (generatableType.owner() != null) {
            codeModels.add(generatableType.owner());
        }
        JClass requestBodyType = CodeModelHelper.findFirstClassBySimpleName(codeModels.toArray(new JCodeModel[codeModels.size()]), requestBodyName);
        if (this.addParameterJavadoc) {
            generatableType.get().javadoc().addParam(StringUtils.uncapitalize((String)requestBodyName) + " The Request Body Payload");
        }
        return generatableType.get().param((JType)requestBodyType, StringUtils.uncapitalize((String)requestBodyName));
    }

    protected JVar paramHttpHeaders(CodeModelHelper.JExtMethod generatableType) {
        JVar paramHttpHeaders = generatableType.get().param(HttpHeaders.class, "httpHeaders");
        if (this.addParameterJavadoc) {
            generatableType.get().javadoc().addParam("httpHeaders The HTTP headers for the request");
        }
        return paramHttpHeaders;
    }
}

