/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.generation.rules.spring;

import com.phoenixnap.oss.ramlapisync.data.ApiActionMetadata;
import com.phoenixnap.oss.ramlapisync.data.ApiBodyMetadata;
import com.phoenixnap.oss.ramlapisync.generation.CodeModelHelper;
import com.phoenixnap.oss.ramlapisync.generation.rules.Rule;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JType;
import java.util.List;
import java.util.concurrent.Callable;
import org.springframework.http.ResponseEntity;

public class SpringCallableResponseEntityRule
implements Rule<JDefinedClass, JType, ApiActionMetadata> {
    @Override
    public JType apply(ApiActionMetadata endpointMetadata, JDefinedClass generatableType) {
        JClass callable = generatableType.owner().ref(Callable.class);
        JClass responseEntity = generatableType.owner().ref(ResponseEntity.class);
        if (!endpointMetadata.getResponseBody().isEmpty()) {
            ApiBodyMetadata apiBodyMetadata = endpointMetadata.getResponseBody().values().iterator().next();
            JClass genericType = CodeModelHelper.findFirstClassBySimpleName(apiBodyMetadata.getCodeModel(), apiBodyMetadata.getName());
            if (apiBodyMetadata.isArray()) {
                JClass arrayType = generatableType.owner().ref(List.class);
                return callable.narrow(responseEntity.narrow(arrayType.narrow(genericType)));
            }
            return callable.narrow(responseEntity.narrow(genericType));
        }
        return callable.narrow(responseEntity.narrow(generatableType.owner().wildcard()));
    }
}

