/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.generation.rules.spring;

import com.phoenixnap.oss.ramlapisync.data.ApiActionMetadata;
import com.phoenixnap.oss.ramlapisync.data.ApiResourceMetadata;
import com.phoenixnap.oss.ramlapisync.generation.rules.ConfigurableRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.GenericJavaClassRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.Rule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.ClassCommentRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.ControllerClassDeclarationRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.ControllerInterfaceDeclarationRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.ControllerMethodSignatureRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.DelegatingMethodBodyRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.ImplementsControllerInterfaceRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.MethodCommentRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.MethodParamsRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.PackageRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.spring.SpringCallableResponseEntityRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.spring.SpringDelegateFieldDeclerationRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.spring.SpringMethodParamsRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.spring.SpringRequestMappingClassAnnotationRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.spring.SpringRequestMappingMethodAnnotationRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.spring.SpringResponseEntityRule;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JMethod;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.CollectionUtils;

public abstract class SpringControllerDecoratorRule
implements ConfigurableRule<JCodeModel, JDefinedClass, ApiResourceMetadata> {
    public static final String CALLABLE_RESPONSE_CONFIGURATION = "callableResponse";
    private boolean callableResponse = false;

    public boolean isCallableResponse() {
        return this.callableResponse;
    }

    public void setCallableResponse(boolean callableResponse) {
        this.callableResponse = callableResponse;
    }

    @Override
    public final JDefinedClass apply(ApiResourceMetadata metadata, JCodeModel generatableType) {
        JDefinedClass generatedInterface = new GenericJavaClassRule().setPackageRule(new PackageRule()).setClassCommentRule(new ClassCommentRule()).setClassRule(new ControllerInterfaceDeclarationRule()).setMethodCommentRule(new MethodCommentRule()).setMethodSignatureRule(new ControllerMethodSignatureRule(this.isCallableResponse() ? new SpringCallableResponseEntityRule() : new SpringResponseEntityRule(), new MethodParamsRule())).apply(metadata, generatableType);
        String delegateFieldName = StringUtils.uncapitalize((String)(generatedInterface.name() + "Delegate"));
        GenericJavaClassRule delegateGenerator = new GenericJavaClassRule().setPackageRule(new PackageRule()).setClassCommentRule(new ClassCommentRule()).addClassAnnotationRule(this.getControllerAnnotationRule()).addClassAnnotationRule(new SpringRequestMappingClassAnnotationRule()).setClassRule(new ControllerClassDeclarationRule("Decorator")).setImplementsExtendsRule(new ImplementsControllerInterfaceRule(generatedInterface)).addFieldDeclarationRule(new SpringDelegateFieldDeclerationRule(delegateFieldName)).setMethodCommentRule(new MethodCommentRule()).addMethodAnnotationRule(new SpringRequestMappingMethodAnnotationRule()).addMethodAnnotationRule(this.getResponseBodyAnnotationRule()).setMethodSignatureRule(new ControllerMethodSignatureRule(this.isCallableResponse() ? new SpringCallableResponseEntityRule() : new SpringResponseEntityRule(), new SpringMethodParamsRule())).setMethodBodyRule(new DelegatingMethodBodyRule(delegateFieldName));
        return delegateGenerator.apply(metadata, generatableType);
    }

    @Override
    public void applyConfiguration(Map<String, String> configuration) {
        if (!CollectionUtils.isEmpty(configuration) && configuration.containsKey(CALLABLE_RESPONSE_CONFIGURATION)) {
            this.setCallableResponse(BooleanUtils.toBoolean((String)configuration.get(CALLABLE_RESPONSE_CONFIGURATION)));
        }
    }

    protected abstract Rule<JDefinedClass, JAnnotationUse, ApiResourceMetadata> getControllerAnnotationRule();

    protected abstract Rule<JMethod, JAnnotationUse, ApiActionMetadata> getResponseBodyAnnotationRule();
}

