/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.generation.rules.spring;

import com.phoenixnap.oss.ramlapisync.data.ApiActionMetadata;
import com.phoenixnap.oss.ramlapisync.data.ApiResourceMetadata;
import com.phoenixnap.oss.ramlapisync.generation.rules.ConfigurableRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.GenericJavaClassRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.Rule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.ClassCommentRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.ControllerInterfaceDeclarationRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.ControllerMethodSignatureRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.MethodCommentRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.basic.PackageRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.spring.SpringCallableResponseEntityRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.spring.SpringMethodParamsRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.spring.SpringRequestMappingClassAnnotationRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.spring.SpringRequestMappingMethodAnnotationRule;
import com.phoenixnap.oss.ramlapisync.generation.rules.spring.SpringResponseEntityRule;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JMethod;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.CollectionUtils;

public abstract class SpringControllerInterfaceRule
implements ConfigurableRule<JCodeModel, JDefinedClass, ApiResourceMetadata> {
    public static final String CALLABLE_RESPONSE_CONFIGURATION = "callableResponse";
    private boolean callableResponse = false;

    public boolean isCallableResponse() {
        return this.callableResponse;
    }

    public void setCallableResponse(boolean callableResponse) {
        this.callableResponse = callableResponse;
    }

    @Override
    public final JDefinedClass apply(ApiResourceMetadata metadata, JCodeModel generatableType) {
        GenericJavaClassRule generator = new GenericJavaClassRule().setPackageRule(new PackageRule()).setClassCommentRule(new ClassCommentRule()).addClassAnnotationRule(this.getControllerAnnotationRule()).addClassAnnotationRule(new SpringRequestMappingClassAnnotationRule()).setClassRule(new ControllerInterfaceDeclarationRule()).setMethodCommentRule(new MethodCommentRule()).addMethodAnnotationRule(new SpringRequestMappingMethodAnnotationRule()).addMethodAnnotationRule(this.getResponseBodyAnnotationRule()).setMethodSignatureRule(new ControllerMethodSignatureRule(this.isCallableResponse() ? new SpringCallableResponseEntityRule() : new SpringResponseEntityRule(), new SpringMethodParamsRule()));
        return generator.apply(metadata, generatableType);
    }

    @Override
    public void applyConfiguration(Map<String, String> configuration) {
        if (!CollectionUtils.isEmpty(configuration) && configuration.containsKey(CALLABLE_RESPONSE_CONFIGURATION)) {
            this.setCallableResponse(BooleanUtils.toBoolean((String)configuration.get(CALLABLE_RESPONSE_CONFIGURATION)));
        }
    }

    protected abstract Rule<JDefinedClass, JAnnotationUse, ApiResourceMetadata> getControllerAnnotationRule();

    protected abstract Rule<JMethod, JAnnotationUse, ApiActionMetadata> getResponseBodyAnnotationRule();
}

