/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.generation.rules.spring;

import com.phoenixnap.oss.ramlapisync.data.ApiResourceMetadata;
import com.phoenixnap.oss.ramlapisync.generation.exception.RuleCanNotProcessModelException;
import com.phoenixnap.oss.ramlapisync.generation.rules.Rule;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class SpringDelegateFieldDeclerationRule
implements Rule<JDefinedClass, JFieldVar, ApiResourceMetadata> {
    private String delegateFieldName = "delegate";

    public SpringDelegateFieldDeclerationRule(String delegateFieldName) {
        if (StringUtils.hasText((String)delegateFieldName)) {
            this.delegateFieldName = delegateFieldName;
        }
    }

    @Override
    public JFieldVar apply(ApiResourceMetadata controllerMetadata, JDefinedClass generatableType) {
        if (!generatableType._implements().hasNext()) {
            throw new RuleCanNotProcessModelException("The class " + generatableType.fullName() + " does not implement a super class that can be delegated to.");
        }
        JClass controllerInterface = (JClass)generatableType._implements().next();
        JFieldVar field = generatableType.field(4, (JType)controllerInterface, this.delegateFieldName);
        field.annotate(Autowired.class);
        return field;
    }
}

