/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.generation.rules.spring;

import com.phoenixnap.oss.ramlapisync.data.ApiResourceMetadata;
import com.phoenixnap.oss.ramlapisync.generation.exception.InvalidCodeModelException;
import com.phoenixnap.oss.ramlapisync.generation.rules.Rule;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JDefinedClass;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;

public class SpringRequestMappingClassAnnotationRule
implements Rule<JDefinedClass, JAnnotationUse, ApiResourceMetadata> {
    @Override
    public JAnnotationUse apply(ApiResourceMetadata controllerMetadata, JDefinedClass generatableType) {
        JAnnotationUse requestMapping = generatableType.annotate(RequestMapping.class);
        requestMapping.param("value", controllerMetadata.getControllerUrl());
        try {
            String mediaType = this.generateMediaType(controllerMetadata);
            if (mediaType != null) {
                requestMapping.param("produces", mediaType);
            }
        }
        catch (Exception e) {
            throw new InvalidCodeModelException("Your model contains an invalid media type", e);
        }
        return requestMapping;
    }

    private String generateMediaType(ApiResourceMetadata controllerMetadata) {
        String ramlMediaType = controllerMetadata.getDocument().getMediaType();
        if (!StringUtils.hasText((String)ramlMediaType)) {
            return null;
        }
        return MediaType.parseMediaType((String)ramlMediaType).toString();
    }
}

