/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.generation.rules.spring;

import com.google.common.base.CaseFormat;
import com.phoenixnap.oss.ramlapisync.data.ApiActionMetadata;
import com.phoenixnap.oss.ramlapisync.data.ApiBodyMetadata;
import com.phoenixnap.oss.ramlapisync.data.ApiParameterMetadata;
import com.phoenixnap.oss.ramlapisync.generation.CodeModelHelper;
import com.phoenixnap.oss.ramlapisync.generation.rules.Rule;
import com.phoenixnap.oss.ramlapisync.naming.NamingHelper;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class SpringRestClientMethodBodyRule
implements Rule<CodeModelHelper.JExtMethod, JMethod, ApiActionMetadata> {
    private String restTemplateFieldName = "restTemplate";
    private String baseUrlFieldName = "baseUrl";

    public SpringRestClientMethodBodyRule(String restTemplateFieldName, String baseUrlFieldName) {
        if (StringUtils.hasText((String)restTemplateFieldName)) {
            this.restTemplateFieldName = restTemplateFieldName;
        }
        if (!StringUtils.isEmpty((Object)baseUrlFieldName)) {
            this.baseUrlFieldName = baseUrlFieldName;
        }
    }

    @Override
    public JMethod apply(ApiActionMetadata endpointMetadata, CodeModelHelper.JExtMethod generatableType) {
        String documentDefaultType;
        JBlock body = generatableType.get().body();
        JCodeModel owner = generatableType.owner();
        JClass httpHeadersClass = owner.ref(HttpHeaders.class);
        JInvocation headersInit = JExpr._new((JClass)httpHeadersClass);
        JVar httpHeaders = null;
        if (endpointMetadata.getInjectHttpHeadersParameter()) {
            for (JVar var : generatableType.get().params()) {
                if (!var.name().equals("httpHeaders")) continue;
                httpHeaders = var;
                break;
            }
        } else {
            httpHeaders = body.decl((JType)httpHeadersClass, "httpHeaders", (JExpression)headersInit);
        }
        body.directStatement("//  Add Accepts Headers and Body Content-Type");
        JClass mediaTypeClass = owner.ref(MediaType.class);
        JClass refArrayListClass = owner.ref(ArrayList.class).narrow(mediaTypeClass);
        JVar acceptsListVar = body.decl((JType)refArrayListClass, "acceptsList", (JExpression)JExpr._new((JClass)refArrayListClass));
        if (endpointMetadata.getRequestBody() != null) {
            body.invoke((JExpression)httpHeaders, "setContentType").arg((JExpression)mediaTypeClass.staticInvoke("valueOf").arg(endpointMetadata.getRequestBodyMime()));
        }
        if (StringUtils.hasText((String)(documentDefaultType = endpointMetadata.getParent().getDocument().getMediaType()))) {
            body.invoke((JExpression)acceptsListVar, "add").arg((JExpression)mediaTypeClass.staticInvoke("valueOf").arg(documentDefaultType));
        } else {
            body.invoke((JExpression)acceptsListVar, "add").arg((JExpression)mediaTypeClass.staticInvoke("valueOf").arg("application/json"));
        }
        if (endpointMetadata.getResponseBody() != null && !endpointMetadata.getResponseBody().isEmpty()) {
            for (String responseMime : endpointMetadata.getResponseBody().keySet()) {
                if (responseMime.equals(documentDefaultType) || responseMime.equals("application/json")) continue;
                body.invoke((JExpression)acceptsListVar, "add").arg((JExpression)mediaTypeClass.staticInvoke("valueOf").arg(responseMime));
            }
        }
        body.invoke((JExpression)httpHeaders, "setAccept").arg((JExpression)acceptsListVar);
        List params = generatableType.get().params();
        LinkedHashMap<String, JVar> methodParamMap = new LinkedHashMap<String, JVar>();
        for (JVar param : params) {
            methodParamMap.put(param.name(), param);
        }
        for (ApiParameterMetadata parameter : endpointMetadata.getRequestHeaders()) {
            JVar param = (JVar)methodParamMap.get(NamingHelper.getParameterName(parameter.getName()));
            String javaParamName = NamingHelper.getParameterName(parameter.getName());
            body._if(((JVar)methodParamMap.get(javaParamName)).ne(JExpr._null()))._then().block().invoke((JExpression)httpHeaders, "add").arg(parameter.getName()).arg((JExpression)JExpr.invoke((JExpression)param, (String)"toString"));
        }
        JClass httpEntityClass = owner.ref(HttpEntity.class);
        JInvocation init = JExpr._new((JClass)httpEntityClass);
        if (endpointMetadata.getRequestBody() != null) {
            init.arg((JExpression)methodParamMap.get(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, endpointMetadata.getRequestBody().getName())));
        }
        init.arg((JExpression)httpHeaders);
        JFieldRef urlRef = JExpr.ref((String)this.baseUrlFieldName);
        JType urlClass = owner._ref(String.class);
        JInvocation targetUrl = urlRef.invoke("concat").arg(endpointMetadata.getResource().getUri());
        JVar url = body.decl(urlClass, "url", (JExpression)targetUrl);
        JVar uriBuilderVar = null;
        JVar uriComponentVar = null;
        JClass builderClass = owner.ref(UriComponentsBuilder.class);
        JInvocation builderInit = builderClass.staticInvoke("fromHttpUrl").arg((JExpression)url);
        if (!CollectionUtils.isEmpty(endpointMetadata.getRequestParameters())) {
            for (ApiParameterMetadata parameter : endpointMetadata.getRequestParameters()) {
                builderInit = builderInit.invoke("queryParam").arg(parameter.getName()).arg((JExpression)methodParamMap.get(NamingHelper.getParameterName(parameter.getName())));
            }
        }
        uriBuilderVar = body.decl((JType)builderClass, "builder", (JExpression)builderInit);
        JClass componentClass = owner.ref(UriComponents.class);
        JInvocation component = uriBuilderVar.invoke("build");
        uriComponentVar = body.decl((JType)componentClass, "uriComponents", (JExpression)component);
        JVar httpEntityVar = body.decl((JType)httpEntityClass, "httpEntity", (JExpression)init);
        JClass httpMethod = null;
        try {
            httpMethod = (JClass)owner._ref(HttpMethod.class);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (!CollectionUtils.isEmpty(endpointMetadata.getPathVariables())) {
            JClass uriParamMap = owner.ref(Map.class).narrow(new Class[]{String.class, Object.class});
            JInvocation uriParamMapInit = JExpr._new((JClass)owner.ref(HashMap.class));
            JVar uriParamMapVar = body.decl((JType)uriParamMap, "uriParamMap", (JExpression)uriParamMapInit);
            endpointMetadata.getPathVariables().forEach(p -> body.invoke((JExpression)uriParamMapVar, "put").arg(p.getName()).arg((JExpression)methodParamMap.get(p.getName())));
            JInvocation expandInvocation = uriComponentVar.invoke("expand").arg((JExpression)uriParamMapVar);
            body.assign((JAssignmentTarget)uriComponentVar, (JExpression)expandInvocation);
        }
        JClass returnType = null;
        if (!endpointMetadata.getResponseBody().isEmpty()) {
            ApiBodyMetadata apiBodyMetadata = endpointMetadata.getResponseBody().values().iterator().next();
            JClass genericType = CodeModelHelper.findFirstClassBySimpleName(apiBodyMetadata.getCodeModel(), apiBodyMetadata.getName());
            if (apiBodyMetadata.isArray()) {
                JClass arrayType = owner.ref(List.class);
                returnType = arrayType.narrow(genericType);
            } else {
                returnType = genericType;
            }
        } else {
            returnType = owner.ref(Object.class);
        }
        JExpression returnExpression = JExpr.dotclass((JClass)returnType);
        if (!CollectionUtils.isEmpty((Collection)returnType.getTypeParameters())) {
            JClass paramTypeRefClass = owner.ref(ParameterizedTypeReference.class);
            paramTypeRefClass = paramTypeRefClass.narrow(returnType);
            body.directStatement("class _P extends " + paramTypeRefClass.fullName() + "{};");
            JInvocation paramTypeRefInit = JExpr._new((JClass)owner.directClass("_P"));
            returnExpression = body.decl((JType)paramTypeRefClass, "typeReference", (JExpression)paramTypeRefInit);
        }
        JInvocation jInvocation = JExpr._this().ref(this.restTemplateFieldName).invoke("exchange");
        jInvocation.arg((JExpression)uriComponentVar.invoke("encode").invoke("toUri"));
        jInvocation.arg((JExpression)httpMethod.staticRef(endpointMetadata.getActionType().name()));
        jInvocation.arg((JExpression)httpEntityVar);
        jInvocation.arg(returnExpression);
        body._return((JExpression)jInvocation);
        return generatableType.get();
    }
}

