/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.generation.rules.spring;

import com.phoenixnap.oss.ramlapisync.data.ApiResourceMetadata;
import com.phoenixnap.oss.ramlapisync.generation.rules.Rule;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JDefinedClass;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RestController;

public class SpringRestControllerAnnotationRule
implements Rule<JDefinedClass, JAnnotationUse, ApiResourceMetadata> {
    private int springVersion;

    protected SpringRestControllerAnnotationRule() {
        this(4);
    }

    public SpringRestControllerAnnotationRule(int springVersion) {
        this.springVersion = springVersion;
    }

    @Override
    public JAnnotationUse apply(ApiResourceMetadata controllerMetadata, JDefinedClass generatableType) {
        Class<Controller> annotationType;
        switch (this.springVersion) {
            case 3: {
                annotationType = Controller.class;
                break;
            }
            case 4: {
                annotationType = RestController.class;
                break;
            }
            default: {
                throw new IllegalStateException("Spring Version not set");
            }
        }
        return generatableType.annotate(annotationType);
    }
}

