/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.javadoc;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.phoenixnap.oss.ramlapisync.javadoc.ClassVisitor;
import com.phoenixnap.oss.ramlapisync.javadoc.FieldVisitor;
import com.phoenixnap.oss.ramlapisync.javadoc.JavaDocStore;
import com.phoenixnap.oss.ramlapisync.javadoc.MethodVisitor;
import com.phoenixnap.oss.ramlapisync.parser.FileSearcher;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaDocExtractor {
    protected static final Logger logger = LoggerFactory.getLogger(JavaDocExtractor.class);
    protected File baseDir = null;
    protected Map<Class<?>, JavaDocStore> javaDocCache = new LinkedHashMap();

    public JavaDocExtractor(File baseDir) {
        if (!(baseDir == null || baseDir.exists() && baseDir.isDirectory())) {
            baseDir = null;
            throw new IllegalStateException("Base Directory Does not exist or is not a directory");
        }
        this.baseDir = baseDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaDocStore getJavaDoc(Class<?> clazz) {
        JavaDocStore javaDoc;
        block14: {
            String classPackage;
            if (clazz.isArray()) {
                clazz = clazz.getComponentType();
            }
            if (this.baseDir == null || clazz.isPrimitive()) {
                return new JavaDocStore();
            }
            String string = classPackage = clazz.getPackage() == null ? "" : clazz.getPackage().getName();
            if (classPackage.startsWith("java") || classPackage.startsWith("org") && (classPackage.startsWith("org.hibernate") || classPackage.startsWith("org.raml") || classPackage.startsWith("org.springframework"))) {
                return new JavaDocStore();
            }
            if (this.javaDocCache.containsKey(clazz)) {
                return this.javaDocCache.get(clazz);
            }
            logger.debug("Getting Javadoc for: " + clazz.getSimpleName());
            javaDoc = new JavaDocStore();
            try {
                File file = FileSearcher.fileSearch(this.baseDir, clazz);
                if (file != null) {
                    CompilationUnit cu;
                    logger.debug("Found: " + file.getAbsolutePath());
                    try (FileInputStream in = new FileInputStream(file);){
                        cu = JavaParser.parse((InputStream)in);
                    }
                    new ClassVisitor(javaDoc).visit(cu, null);
                    new MethodVisitor(javaDoc).visit(cu, null);
                    new FieldVisitor(javaDoc).visit(cu, null);
                    break block14;
                }
                logger.warn("*** WARNING: Missing Source for: " + clazz.getSimpleName() + ". JavaDoc Unavailable.");
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        if (clazz.getInterfaces() != null && clazz.getInterfaces().length > 0) {
            for (Class<?> interfaceClass : clazz.getInterfaces()) {
                javaDoc.merge(this.getJavaDoc(interfaceClass));
            }
        }
        if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Object.class)) {
            javaDoc.merge(this.getJavaDoc(clazz.getSuperclass()));
        }
        this.javaDocCache.put(clazz, javaDoc);
        return javaDoc;
    }
}

