/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.javadoc;

import com.phoenixnap.oss.ramlapisync.javadoc.JavaDocEntry;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;

public class JavaDocStore {
    private Map<String, JavaDocEntry> javaDocStore = new LinkedHashMap<String, JavaDocEntry>();

    public void merge(JavaDocStore javaDocStore) {
        if (javaDocStore != null) {
            for (Map.Entry<String, JavaDocEntry> entry : javaDocStore.javaDocStore.entrySet()) {
                this.putValue(entry.getKey(), entry.getValue());
            }
        }
    }

    private String getStringConvention(Class<?> clazz) {
        return "@class";
    }

    public void setJavaDoc(Class<?> clazz, String javaDoc) {
        this.setClassJavaDoc(javaDoc);
    }

    public void setClassJavaDoc(String javaDoc) {
        this.putValue(this.getStringConvention(null), javaDoc);
    }

    public void setJavaDoc(Method method, String javaDoc) {
        this.setJavaDoc(method.getName(), method.getParameterCount(), javaDoc);
    }

    public void setJavaDoc(String fieldName, String javaDoc) {
        this.putValue("@field" + fieldName, javaDoc);
    }

    public void setJavaDoc(String methodName, int methodParameterCount, String javaDoc) {
        this.putValue(methodName + methodParameterCount, javaDoc);
    }

    public JavaDocEntry getJavaDoc(Method method) {
        return this.getJavaDoc(method.getName(), method.getParameterCount());
    }

    public JavaDocEntry getJavaDoc(String methodName, int parameterCount) {
        return this.javaDocStore.get(methodName + parameterCount);
    }

    public JavaDocEntry getJavaDoc(String fieldName) {
        return this.javaDocStore.get("@field" + fieldName);
    }

    private void putValue(String key, JavaDocEntry entry) {
        JavaDocEntry existingEntry = this.javaDocStore.get(key);
        if (existingEntry == null) {
            this.javaDocStore.put(key, entry);
        } else {
            existingEntry.merge(entry);
        }
    }

    private void putValue(String key, String rawEntry) {
        this.putValue(key, new JavaDocEntry(rawEntry));
    }

    public String getJavaDocComment(Class<?> clazz) {
        JavaDocEntry docEntry = this.javaDocStore.get(this.getStringConvention(clazz));
        if (docEntry != null) {
            return docEntry.getComment();
        }
        return null;
    }

    public String toString() {
        String out = "";
        for (Map.Entry<String, JavaDocEntry> entry : this.javaDocStore.entrySet()) {
            out = out + "-" + entry.getKey() + " : " + entry.getValue() + "\n";
        }
        return out;
    }
}

