/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.naming;

import com.phoenixnap.oss.ramlapisync.naming.SchemaHelper;
import com.phoenixnap.oss.ramlapisync.raml.RamlAction;
import com.phoenixnap.oss.ramlapisync.raml.RamlActionType;
import com.phoenixnap.oss.ramlapisync.raml.RamlResource;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsonschema2pojo.util.NameHelper;
import org.raml.parser.utils.Inflector;
import org.springframework.util.StringUtils;

public class NamingHelper {
    private static final Pattern CLASS_SUFFIXES_TO_CLEAN = Pattern.compile("^(.+)(services|service|impl|class|controller)", 2);
    private static final Pattern CONTENT_TYPE_VERSION = Pattern.compile("[^v]*(v[\\d\\.]*).*", 2);
    private static NameHelper cachedNameHelper;

    private static NameHelper getNameHelper() {
        if (cachedNameHelper != null) {
            return cachedNameHelper;
        }
        cachedNameHelper = new NameHelper(SchemaHelper.getDefaultGenerationConfig());
        return cachedNameHelper;
    }

    public static String convertContentTypeToQualifier(String contentType) {
        String version;
        if (contentType.equals("application/json")) {
            return "AsJson";
        }
        if (contentType.equals("application/octet-stream")) {
            return "AsBinary";
        }
        if (contentType.equals("text/plain") || contentType.equals("text/html")) {
            return "AsText";
        }
        Matcher versionMatcher = CONTENT_TYPE_VERSION.matcher(contentType);
        if (versionMatcher.find() && (version = versionMatcher.group(1)) != null) {
            return StringUtils.capitalize((String)version).replace(".", "_");
        }
        int seperatorIndex = contentType.indexOf("/");
        if (seperatorIndex != -1 && seperatorIndex < contentType.length()) {
            String candidate = contentType.substring(seperatorIndex + 1).toLowerCase();
            String out = "";
            if (candidate.contains("json")) {
                candidate = candidate.replace("json", "");
                out = out + "AsJson";
            }
            if (StringUtils.hasText((String)(candidate = StringUtils.deleteAny((String)candidate, (String)" ,.+=-'\"\\|~`#$%^&\n\t")))) {
                out = StringUtils.capitalize((String)candidate) + out;
            }
            return "_" + out;
        }
        return "";
    }

    public static boolean isUriParamResource(String resource) {
        if (resource == null) {
            return false;
        }
        return (resource = NamingHelper.cleanLeadingAndTrailingNewLineAndChars(resource.toLowerCase())).startsWith("{") && resource.endsWith("}");
    }

    public static boolean isValidJavaClassName(String input) {
        if (!StringUtils.hasText((String)input)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(input.charAt(0))) {
            return false;
        }
        if (input.length() > 1) {
            for (int i = 1; i < input.length(); ++i) {
                if (Character.isJavaIdentifierPart(input.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static String cleanForJavadoc(String input) {
        return NamingHelper.cleanLeadingAndTrailingNewLineAndChars(input);
    }

    public static String cleanLeadingAndTrailingNewLineAndChars(String input) {
        if (!StringUtils.hasText((String)input)) {
            return input;
        }
        String output = input;
        output = output.replaceAll("[\\s]+\\*[\\s]+", " ");
        while (output.startsWith("/") || output.startsWith("\n") || output.startsWith("*") || output.startsWith("-") || output.startsWith("\t") || output.startsWith(" ") || output.startsWith("\\")) {
            output = output.substring(1);
        }
        while (output.endsWith("/") || output.endsWith("\n") || output.endsWith(" ") || output.endsWith(",") || output.endsWith("\t") || output.endsWith("-") || output.endsWith("*")) {
            output = output.substring(0, output.length() - 1);
        }
        return output;
    }

    public static String convertClassName(Class<?> clazz) {
        String convertedName = clazz.getSimpleName();
        boolean clean = true;
        do {
            Matcher cleaner;
            if ((cleaner = CLASS_SUFFIXES_TO_CLEAN.matcher(convertedName)).matches()) {
                if (cleaner.group(1) == null || cleaner.group(1).length() <= 0) continue;
                convertedName = cleaner.group(1);
                continue;
            }
            clean = false;
        } while (clean);
        return StringUtils.uncapitalize((String)convertedName);
    }

    public static String resolveProperties(String inputString) {
        if (!StringUtils.hasText((String)inputString)) {
            return inputString;
        }
        String tempString = inputString.trim();
        String outString = "";
        int startIndex = 0;
        while (tempString.indexOf("${", startIndex) != -1) {
            String key;
            String defaultString;
            int defaultPos;
            int startsWithPos = tempString.indexOf("${", startIndex);
            int endsWithPos = tempString.indexOf("}", startsWithPos + 2);
            int nextBracket = tempString.indexOf("{", startsWithPos + 2);
            if (nextBracket != -1 && endsWithPos > nextBracket) {
                endsWithPos = tempString.indexOf("}", endsWithPos + 1);
            }
            if ((defaultPos = tempString.lastIndexOf(":", endsWithPos)) < startsWithPos) {
                defaultPos = -1;
            }
            if (startsWithPos == -1 || endsWithPos == -1) continue;
            String value = tempString.substring(startsWithPos + 2, endsWithPos);
            if (defaultPos != -1) {
                defaultString = value.substring(value.lastIndexOf(":") + 1);
                key = value.substring(0, value.lastIndexOf(":"));
            } else {
                key = value;
                defaultString = value;
            }
            outString = outString + tempString.substring(startIndex, startsWithPos) + System.getProperty(key, defaultString);
            startIndex = endsWithPos + 1;
        }
        if (startIndex < tempString.length()) {
            outString = outString + tempString.substring(startIndex);
        }
        return outString;
    }

    public static String getResourceName(RamlResource resource, boolean singularize) {
        String url = resource.getRelativeUri();
        if (StringUtils.hasText((String)url) && url.contains("/") && url.lastIndexOf("/") < url.length()) {
            return NamingHelper.getResourceName(url.substring(url.lastIndexOf("/") + 1), singularize);
        }
        return null;
    }

    public static String getResourceName(String resource, boolean singularize) {
        if (StringUtils.hasText((String)resource)) {
            String resourceName = StringUtils.capitalize((String)resource);
            if (singularize) {
                resourceName = Inflector.singularize((String)resourceName);
            }
            resourceName = NamingHelper.cleanNameForJava(resourceName);
            return resourceName;
        }
        return null;
    }

    public static String getParameterName(String name) {
        return StringUtils.uncapitalize((String)NamingHelper.cleanNameForJava(name));
    }

    private static String cleanNameForJava(String resourceName) {
        String outString = resourceName;
        if (StringUtils.hasText((String)resourceName) && StringUtils.hasText((String)(outString = NamingHelper.getNameHelper().normalizeName(resourceName)))) {
            outString = outString.replaceAll("[^0-9a-zA-Z_$]", "");
        }
        return outString;
    }

    public static String getActionName(RamlResource controllerizedResource, RamlResource resource, RamlAction action, RamlActionType actionType) {
        String url = resource.getUri();
        if (controllerizedResource != resource && StringUtils.countOccurrencesOf((String)url, (String)"{") < StringUtils.countOccurrencesOf((String)url, (String)"/") - 1) {
            url = url.replace(controllerizedResource.getUri(), "");
        }
        if (StringUtils.hasText((String)url)) {
            String[] splitUrl = url.split("/");
            String name = "";
            int nonIdsParsed = 0;
            boolean singularizeNext = false;
            for (int index = splitUrl.length - 1; nonIdsParsed < 2 && index >= 0; --index) {
                String segment = splitUrl[index];
                if (segment.contains("{") && segment.contains("}")) {
                    if (index > 0 && index == splitUrl.length - 1) {
                        String peek = splitUrl[index - 1].toLowerCase();
                        name = segment.toLowerCase().contains(Inflector.singularize((String)peek)) ? name + "ById" : name + "By" + StringUtils.capitalize((String)segment.substring(1, segment.length() - 1));
                    }
                    singularizeNext = true;
                    continue;
                }
                segment = NamingHelper.cleanNameForJava(segment);
                if (singularizeNext) {
                    name = !segment.endsWith("details") ? Inflector.singularize((String)StringUtils.capitalize((String)segment)) + name : StringUtils.capitalize((String)segment) + name;
                    singularizeNext = false;
                } else {
                    name = StringUtils.capitalize((String)segment) + name;
                }
                ++nonIdsParsed;
                if (!singularizeNext) continue;
                singularizeNext = false;
            }
            boolean collection = false;
            String tail = splitUrl[splitUrl.length - 1];
            if (!Inflector.singularize((String)tail).equals(tail) && !tail.endsWith("details")) {
                collection = true;
            }
            String prefix = NamingHelper.convertActionTypeToIntent(actionType, collection);
            if (collection && RamlActionType.POST.equals((Object)actionType)) {
                name = Inflector.singularize((String)name);
            }
            return prefix + name;
        }
        return null;
    }

    private static String convertActionTypeToIntent(RamlActionType actionType, boolean isTargetCollection) {
        switch (actionType) {
            case DELETE: {
                return "delete";
            }
            case GET: {
                return "get";
            }
            case POST: {
                if (isTargetCollection) {
                    return "create";
                }
            }
            case PUT: {
                return "update";
            }
            case PATCH: {
                return "modify";
            }
        }
        return "do";
    }

    public static String getDefaultModelPackage() {
        return ".model";
    }
}

