/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.naming;

import com.phoenixnap.oss.ramlapisync.raml.RamlAction;
import com.phoenixnap.oss.ramlapisync.raml.RamlMimeType;
import com.phoenixnap.oss.ramlapisync.raml.RamlResource;
import com.phoenixnap.oss.ramlapisync.raml.RamlResourceRoot;
import com.phoenixnap.oss.ramlapisync.raml.RamlResponse;
import com.phoenixnap.oss.ramlapisync.raml.RamlRoot;
import java.util.Map;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class RamlHelper {
    public static void mergeResources(RamlResource existing, RamlResource resource, boolean addActions) {
        Map<String, RamlResource> existingChildResources = existing.getResources();
        Map<String, RamlResource> newChildResources = resource.getResources();
        for (String newChildKey : newChildResources.keySet()) {
            if (!existingChildResources.containsKey(newChildKey)) {
                existing.addResource(newChildKey, newChildResources.get(newChildKey));
                continue;
            }
            RamlHelper.mergeResources(existingChildResources.get(newChildKey), newChildResources.get(newChildKey), addActions);
        }
        if (addActions) {
            existing.addActions(resource.getActions());
        }
    }

    public static void mergeResources(RamlRoot raml, RamlResource resource, boolean addActions) {
        RamlResource existingResource = raml.getResource(resource.getRelativeUri());
        if (existingResource == null) {
            raml.addResource(resource.getRelativeUri(), resource);
        } else {
            RamlHelper.mergeResources(existingResource, resource, addActions);
        }
    }

    public static void mergeActions(RamlAction existingAction, RamlAction newAction) {
        RamlResponse existingSuccessfulResponse = RamlHelper.getSuccessfulResponse(existingAction);
        RamlResponse successfulResponse = RamlHelper.getSuccessfulResponse(newAction);
        if (existingSuccessfulResponse != null && existingSuccessfulResponse.hasBody() && successfulResponse != null && successfulResponse.hasBody()) {
            for (Map.Entry<String, RamlMimeType> body : successfulResponse.getBody().entrySet()) {
                existingSuccessfulResponse.addToBody(body.getKey(), body.getValue());
            }
        }
    }

    public static RamlResponse getSuccessfulResponse(RamlAction action) {
        String[] successfulResponses;
        for (String code : successfulResponses = new String[]{"200", "201", "202"}) {
            if (action == null || CollectionUtils.isEmpty(action.getResponses()) || !action.getResponses().containsKey(code)) continue;
            return action.getResponses().get(code);
        }
        return null;
    }

    public static void removeResourceTree(RamlRoot model, String urlPrefixToIgnore) {
        if (StringUtils.hasText((String)urlPrefixToIgnore)) {
            String[] urlParts = urlPrefixToIgnore.split("/");
            String firstResourcePart = null;
            RamlResourceRoot pointerResource = null;
            for (String part : urlParts) {
                if (!StringUtils.hasText((String)part)) continue;
                if ((pointerResource = pointerResource != null ? pointerResource.getResource("/" + part) : (model.getResources().get("/") != null ? model.getResource("/").getResource("/" + part) : model.getResource("/" + part))) == null) {
                    throw new IllegalStateException("Attempting to ignore url prefix [" + urlPrefixToIgnore + "] and failed to find resource on [" + part + "]");
                }
                if (firstResourcePart != null) continue;
                firstResourcePart = "/" + part;
            }
            RamlResourceRoot parentResource = model;
            if (model.getResource("/") != null) {
                parentResource = model.getResource("/");
            }
            parentResource.removeResource(firstResourcePart);
            RamlHelper.removeUri(pointerResource.getResources(), urlPrefixToIgnore);
            parentResource.addResources(pointerResource.getResources());
        }
    }

    private static void removeUri(Map<String, RamlResource> resources, String urlPrefixToIgnore) {
        for (RamlResource resource : resources.values()) {
            resource.setParentUri(resource.getParentUri().replace(urlPrefixToIgnore, ""));
            resource.setRelativeUri(resource.getRelativeUri().replace(urlPrefixToIgnore, ""));
            RamlHelper.removeUri(resource.getResources(), urlPrefixToIgnore);
        }
    }
}

