/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.naming;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ValueTypeSchema;
import com.phoenixnap.oss.ramlapisync.data.ApiBodyMetadata;
import com.phoenixnap.oss.ramlapisync.data.ApiParameterMetadata;
import com.phoenixnap.oss.ramlapisync.javadoc.JavaDocEntry;
import com.phoenixnap.oss.ramlapisync.javadoc.JavaDocStore;
import com.phoenixnap.oss.ramlapisync.naming.NamingHelper;
import com.phoenixnap.oss.ramlapisync.naming.TypeHelper;
import com.phoenixnap.oss.ramlapisync.raml.RamlMimeType;
import com.phoenixnap.oss.ramlapisync.raml.RamlModelFactory;
import com.phoenixnap.oss.ramlapisync.raml.RamlModelFactoryOfFactories;
import com.phoenixnap.oss.ramlapisync.raml.RamlParamType;
import com.phoenixnap.oss.ramlapisync.raml.RamlQueryParameter;
import com.phoenixnap.oss.ramlapisync.raml.RamlRoot;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.jsonschema2pojo.Annotator;
import org.jsonschema2pojo.DefaultGenerationConfig;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Jackson2Annotator;
import org.jsonschema2pojo.SchemaGenerator;
import org.jsonschema2pojo.SchemaMapper;
import org.jsonschema2pojo.SchemaStore;
import org.jsonschema2pojo.rules.RuleFactory;
import org.raml.parser.utils.Inflector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class SchemaHelper {
    protected static final Logger logger = LoggerFactory.getLogger(SchemaHelper.class);
    private static String JSON_SCHEMA_IDENT = "http://jsonschema.net";

    public static Map<String, RamlQueryParameter> convertParameterToQueryParameter(Parameter param, String paramComment) {
        RamlQueryParameter queryParam = RamlModelFactoryOfFactories.createRamlModelFactory().createRamlQueryParameter();
        ApiParameterMetadata parameterMetadata = new ApiParameterMetadata(param);
        RamlParamType type = SchemaHelper.mapSimpleType(param.getType());
        if (type == null) {
            throw new IllegalArgumentException("This method is only applicable to simple types or primitives");
        }
        if (StringUtils.hasText((String)paramComment)) {
            queryParam.setDescription(paramComment);
        }
        queryParam.setDisplayName(parameterMetadata.getName());
        queryParam.setType(SchemaHelper.mapSimpleType(param.getType()));
        if (StringUtils.hasText((String)parameterMetadata.getExample())) {
            queryParam.setExample(parameterMetadata.getExample());
        }
        queryParam.setRequired(!parameterMetadata.isNullable());
        queryParam.setRepeat(param.getType().isArray());
        return Collections.singletonMap(parameterMetadata.getName(), queryParam);
    }

    public static String resolveSchema(String schema, RamlRoot document) {
        if (document == null || schema == null || schema.indexOf("{") != -1) {
            return null;
        }
        if (document.getSchemas() != null && !document.getSchemas().isEmpty()) {
            for (Map<String, String> map : document.getSchemas()) {
                if (!map.containsKey(schema)) continue;
                return map.get(schema);
            }
        }
        return null;
    }

    public static Map<String, RamlQueryParameter> convertClassToQueryParameters(Parameter param, JavaDocStore javaDocStore) {
        TreeMap<String, RamlQueryParameter> outParams = new TreeMap<String, RamlQueryParameter>();
        if (param == null || param.equals(Void.class)) {
            return outParams;
        }
        ApiParameterMetadata parameterMetadata = new ApiParameterMetadata(param);
        if (SchemaHelper.mapSimpleType(param.getType()) != null) {
            throw new IllegalArgumentException("This method should only be called on non primitive classes which will be broken down into query parameters");
        }
        try {
            RamlModelFactory ramlModelFactory = RamlModelFactoryOfFactories.createRamlModelFactory();
            for (Field field : param.getType().getDeclaredFields()) {
                JavaDocEntry paramComment;
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || Modifier.isVolatile(field.getModifiers())) continue;
                RamlQueryParameter queryParam = ramlModelFactory.createRamlQueryParameter();
                JavaDocEntry javaDocEntry = paramComment = javaDocStore == null ? null : javaDocStore.getJavaDoc(field.getName());
                if (paramComment != null && StringUtils.hasText((String)paramComment.getComment())) {
                    queryParam.setDescription(paramComment.getComment());
                }
                queryParam.setDisplayName(field.getName());
                RamlParamType simpleType = SchemaHelper.mapSimpleType(field.getType());
                queryParam.setType(simpleType == null ? RamlParamType.STRING : simpleType);
                queryParam.setRequired(parameterMetadata.isNullable());
                queryParam.setRepeat(false);
                outParams.put(field.getName(), queryParam);
            }
            return outParams;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static String convertClassToJsonSchema(ApiParameterMetadata clazz, String responseDescription, JavaDocStore javaDocStore) {
        if (clazz == null || clazz.equals(Void.class)) {
            return "{}";
        }
        try {
            ObjectMapper m = new ObjectMapper();
            JsonSchema jsonSchema = SchemaHelper.extractSchemaInternal(clazz.getType(), clazz.getGenericType(), responseDescription, javaDocStore, m);
            return m.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonSchema);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static String convertClassToJsonSchema(Type clazz, String responseDescription, JavaDocStore javaDocStore) {
        if (clazz == null || clazz.equals(Void.class)) {
            return "{}";
        }
        try {
            ObjectMapper m = new ObjectMapper();
            JsonSchema jsonSchema = SchemaHelper.extractSchemaInternal(clazz, TypeHelper.inferGenericType(clazz), responseDescription, javaDocStore, m);
            return m.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonSchema);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static JsonSchema extractSchemaInternal(Type clazz, Type genericType, String responseDescription, JavaDocStore javaDocStore, ObjectMapper m) throws JsonMappingException {
        SchemaFactoryWrapper visitor = new SchemaFactoryWrapper();
        if (genericType != null) {
            try {
                m.acceptJsonFormatVisitor(m.constructType(genericType), (JsonFormatVisitorWrapper)visitor);
            }
            catch (Exception ex) {
                logger.error("Unable to add JSON visitor for " + genericType.toString());
            }
        }
        try {
            m.acceptJsonFormatVisitor(m.constructType(clazz), (JsonFormatVisitorWrapper)visitor);
        }
        catch (Exception ex) {
            logger.error("Unable to add JSON visitor for " + clazz.toString());
        }
        JsonSchema jsonSchema = visitor.finalSchema();
        if (jsonSchema instanceof ObjectSchema && javaDocStore != null) {
            ObjectSchema objectSchema = (ObjectSchema)jsonSchema;
            if (objectSchema.getProperties() != null) {
                for (Map.Entry cSchema : objectSchema.getProperties().entrySet()) {
                    JavaDocEntry javaDocEntry = javaDocStore.getJavaDoc((String)cSchema.getKey());
                    if (javaDocEntry == null || !StringUtils.hasText((String)javaDocEntry.getComment())) continue;
                    ((JsonSchema)cSchema.getValue()).setDescription(javaDocEntry.getComment());
                }
            }
        } else if (jsonSchema instanceof ValueTypeSchema && StringUtils.hasText((String)responseDescription)) {
            ValueTypeSchema valueTypeSchema = (ValueTypeSchema)jsonSchema;
            valueTypeSchema.setDescription(responseDescription);
        } else if (jsonSchema instanceof ArraySchema && genericType != null) {
            ArraySchema arraySchema = (ArraySchema)jsonSchema;
            arraySchema.setItemsSchema(SchemaHelper.extractSchemaInternal(genericType, TypeHelper.inferGenericType(genericType), responseDescription, javaDocStore, m));
        }
        return jsonSchema;
    }

    public static RamlParamType mapSimpleType(Class<?> clazz) {
        Class<?> targetClazz = clazz;
        if (targetClazz.isArray() && clazz.getComponentType() != null) {
            targetClazz = clazz.getComponentType();
        }
        if (targetClazz.equals(Long.TYPE) || targetClazz.equals(Long.class) || targetClazz.equals(Integer.TYPE) || targetClazz.equals(Integer.class) || targetClazz.equals(Short.TYPE) || targetClazz.equals(Short.class) || targetClazz.equals(Byte.TYPE) || targetClazz.equals(Byte.class)) {
            return RamlParamType.INTEGER;
        }
        if (targetClazz.equals(Float.TYPE) || targetClazz.equals(Float.class) || targetClazz.equals(Double.TYPE) || targetClazz.equals(Double.class) || targetClazz.equals(BigDecimal.class)) {
            return RamlParamType.NUMBER;
        }
        if (targetClazz.equals(Boolean.class) || targetClazz.equals(Boolean.TYPE)) {
            return RamlParamType.BOOLEAN;
        }
        if (targetClazz.equals(String.class)) {
            return RamlParamType.STRING;
        }
        return null;
    }

    public static Class<?> mapSimpleType(RamlParamType param) {
        switch (param) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case DATE: {
                return Date.class;
            }
            case INTEGER: {
                return Long.class;
            }
            case NUMBER: {
                return BigDecimal.class;
            }
            case FILE: {
                return MultipartFile.class;
            }
        }
        return String.class;
    }

    public static String extractNameFromSchema(String schema, String schemaName, String fallbackName) {
        String resolvedName = null;
        if (schema != null) {
            String javaType;
            int startIdx = 0;
            String type = SchemaHelper.extractTopItem("type", schema, startIdx);
            if (type != null && type.equalsIgnoreCase("array")) {
                String ref;
                int itemsIdx = schema.indexOf("\"items\"");
                if (itemsIdx != -1) {
                    startIdx = itemsIdx + 7;
                }
                if ((ref = SchemaHelper.extractTopItem("$ref", schema, startIdx)) != null) {
                    logger.info("Loading referenced schema " + ref);
                    ref = ref.replace("classpath:", "");
                    try {
                        schema = IOUtils.toString((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream(ref), (String)"UTF-8");
                        startIdx = 0;
                    }
                    catch (IOException e) {
                        logger.info("Erro Loading referenced schema " + ref, (Throwable)e);
                    }
                }
            }
            if (StringUtils.hasText((String)(javaType = SchemaHelper.extractTopItem("javaType", schema, startIdx)))) {
                int dotIdx = javaType.lastIndexOf(".");
                if (dotIdx > -1) {
                    javaType = javaType.substring(dotIdx + 1);
                }
                resolvedName = javaType;
            } else {
                String id = SchemaHelper.extractTopItem("id", schema, startIdx);
                if (StringUtils.hasText((String)id)) {
                    if (id.startsWith("urn:") && id.lastIndexOf(":") + 1 < id.length()) {
                        id = id.substring(id.lastIndexOf(":") + 1);
                    } else if (id.startsWith(JSON_SCHEMA_IDENT) && id.length() > JSON_SCHEMA_IDENT.length() + 3) {
                        id = id.substring(JSON_SCHEMA_IDENT.length());
                    }
                    resolvedName = StringUtils.capitalize((String)id);
                }
                if (!NamingHelper.isValidJavaClassName(resolvedName)) {
                    if (NamingHelper.isValidJavaClassName(schemaName)) {
                        return Inflector.capitalize((String)schemaName);
                    }
                    resolvedName = fallbackName;
                }
            }
        }
        return resolvedName;
    }

    private static String extractTopItem(String searchString, String schema, int startIdx) {
        String extracted = null;
        int propIdx = schema.indexOf("\"properties\"", startIdx);
        if (propIdx == -1) {
            propIdx = Integer.MAX_VALUE;
        }
        int idIdx = schema.indexOf("\"" + searchString + "\"", startIdx);
        int secondIdIdx = schema.indexOf("\"" + searchString + "\"", idIdx + 1);
        if (secondIdIdx != -1 && propIdx > secondIdIdx) {
            idIdx = secondIdIdx;
        }
        if (idIdx != -1 && propIdx > idIdx) {
            int valueStartIdx = schema.indexOf("\"", idIdx + (searchString.length() + 2));
            int valueEndIdx = schema.indexOf("\"", valueStartIdx + 1);
            extracted = schema.substring(valueStartIdx + 1, valueEndIdx);
        }
        return extracted;
    }

    public static ApiBodyMetadata mapSchemaToPojo(RamlRoot document, String schema, String basePackage, String name, String schemaLocation) {
        String resolvedName = null;
        String schemaName = schema;
        String resolvedSchema = SchemaHelper.resolveSchema(schema, document);
        if (resolvedSchema == null) {
            resolvedSchema = schema;
            schemaName = null;
        }
        resolvedName = SchemaHelper.extractNameFromSchema(resolvedSchema, schemaName, name);
        JCodeModel codeModel = SchemaHelper.buildBodyJCodeModel(basePackage, StringUtils.hasText((String)schemaLocation) ? schemaLocation : "classpath:/", resolvedName, resolvedSchema, null, null);
        if (codeModel != null) {
            if (codeModel.countArtifacts() == 1) {
                try {
                    Iterator packages = codeModel.packages();
                    JPackage nextPackage = (JPackage)packages.next();
                    while (!nextPackage.classes().hasNext() && packages.hasNext()) {
                        nextPackage = (JPackage)packages.next();
                    }
                    resolvedName = ((JDefinedClass)nextPackage.classes().next()).name();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            return new ApiBodyMetadata(resolvedName, resolvedSchema, codeModel);
        }
        return null;
    }

    public static JCodeModel buildBodyJCodeModel(String basePackage, String schemaLocation, String name, String schema, GenerationConfig config, Annotator annotator) {
        JCodeModel codeModel = new JCodeModel();
        SchemaStore schemaStore = new SchemaStore();
        if (config == null) {
            config = SchemaHelper.getDefaultGenerationConfig();
        }
        if (annotator == null) {
            annotator = new Jackson2Annotator();
        }
        RuleFactory ruleFactory = new RuleFactory(config, annotator, schemaStore);
        SchemaMapper mapper = new SchemaMapper(ruleFactory, new SchemaGenerator());
        boolean useParent = StringUtils.hasText((String)schemaLocation);
        try {
            if (useParent) {
                mapper.generate(codeModel, name, basePackage, schema, new URI(schemaLocation));
            } else {
                mapper.generate(codeModel, name, basePackage, schema);
            }
        }
        catch (Exception e) {
            if (useParent && e.getMessage().contains("classpath")) {
                logger.debug("Referenced Schema contains self $refs or not found in classpath. Regenerating model withouth classpath: for " + name);
                codeModel = new JCodeModel();
                try {
                    mapper.generate(codeModel, name, basePackage, schema);
                    return codeModel;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            logger.error("Error generating pojo from schema" + name, (Throwable)e);
            return null;
        }
        return codeModel;
    }

    public static GenerationConfig getDefaultGenerationConfig() {
        return SchemaHelper.getGenerationConfig(true, false, false, false);
    }

    public static GenerationConfig getGenerationConfig(final Boolean generateBuilders, final Boolean includeAdditionalProperties, final Boolean includeDynamicAccessors, final Boolean useLongIntegers) {
        return new DefaultGenerationConfig(){

            public boolean isGenerateBuilders() {
                if (generateBuilders != null) {
                    return generateBuilders;
                }
                return true;
            }

            public boolean isIncludeAdditionalProperties() {
                if (includeAdditionalProperties != null) {
                    return includeAdditionalProperties;
                }
                return false;
            }

            public boolean isIncludeDynamicAccessors() {
                if (includeDynamicAccessors != null) {
                    return includeDynamicAccessors;
                }
                return false;
            }

            public boolean isUseLongIntegers() {
                if (useLongIntegers != null) {
                    return useLongIntegers;
                }
                return super.isUseLongIntegers();
            }
        };
    }

    public static boolean containsBodySchema(Map<String, RamlMimeType> body, RamlRoot document, boolean checkForValidSchema) {
        if (CollectionUtils.isEmpty(body)) {
            return false;
        }
        for (Map.Entry<String, RamlMimeType> bodyMime : body.entrySet()) {
            RamlMimeType mime = bodyMime.getValue();
            if (mime == null || !StringUtils.hasText((String)mime.getSchema())) continue;
            if (checkForValidSchema) {
                try {
                    ApiBodyMetadata pojo = SchemaHelper.mapSchemaToPojo(document, mime.getSchema(), "com.phoenixnap.oss.stylecheck", "ClazzUnderCheck", null);
                    return pojo != null;
                }
                catch (Exception ex) {
                    logger.warn("Possible Schema excheption", (Throwable)ex);
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

