/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.parser;

import com.phoenixnap.oss.ramlapisync.data.ApiParameterMetadata;
import com.phoenixnap.oss.ramlapisync.javadoc.JavaDocEntry;
import com.phoenixnap.oss.ramlapisync.javadoc.JavaDocExtractor;
import com.phoenixnap.oss.ramlapisync.javadoc.JavaDocStore;
import com.phoenixnap.oss.ramlapisync.naming.Pair;
import com.phoenixnap.oss.ramlapisync.naming.SchemaHelper;
import com.phoenixnap.oss.ramlapisync.naming.TypeHelper;
import com.phoenixnap.oss.ramlapisync.raml.RamlAction;
import com.phoenixnap.oss.ramlapisync.raml.RamlActionType;
import com.phoenixnap.oss.ramlapisync.raml.RamlMimeType;
import com.phoenixnap.oss.ramlapisync.raml.RamlModelFactory;
import com.phoenixnap.oss.ramlapisync.raml.RamlModelFactoryOfFactories;
import com.phoenixnap.oss.ramlapisync.raml.RamlParamType;
import com.phoenixnap.oss.ramlapisync.raml.RamlQueryParameter;
import com.phoenixnap.oss.ramlapisync.raml.RamlResource;
import com.phoenixnap.oss.ramlapisync.raml.RamlResponse;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.async.DeferredResult;

public abstract class ResourceParser {
    protected static final Logger logger = LoggerFactory.getLogger(ResourceParser.class);
    protected static final Pattern IGNORE_METHOD_REGEX = Pattern.compile("^(equals|hashCode|clone|finalize|getClass|notify|notifyAll|toString|wait)", 2);
    protected static final String CSRF_HEADER = "X-CSRF-TOKEN";
    public static final String CATCH_ALL_MEDIA_TYPE = "application/everything";
    protected JavaDocExtractor javaDocs;
    protected String version;
    protected String defaultMediaType;

    public ResourceParser(File javaDocPath, String version, String defaultMediaType) {
        this.version = version;
        this.defaultMediaType = defaultMediaType;
        this.javaDocs = new JavaDocExtractor(javaDocPath);
    }

    private void getMethodsFromService(Class<?> clazz, JavaDocStore javaDoc, RamlResource parentResource) {
        try {
            for (Method method : clazz.getMethods()) {
                if (IGNORE_METHOD_REGEX.matcher(method.getName()).matches() || !this.shouldAddMethodToApi(method)) continue;
                this.extractAndAppendResourceInfo(clazz, method, javaDoc.getJavaDoc(method), parentResource);
            }
        }
        catch (NoClassDefFoundError nEx) {
            logger.error("Unable to get methods - skipping class " + clazz, (Throwable)nEx);
        }
    }

    public void setJavaDocs(JavaDocExtractor javaDocs) {
        this.javaDocs = javaDocs;
    }

    public static boolean doesActionTypeSupportRequestBody(RamlActionType target) {
        return target.equals((Object)RamlActionType.POST) || target.equals((Object)RamlActionType.PUT);
    }

    public static boolean doesActionTypeSupportMultipartMime(RamlActionType target) {
        return target.equals((Object)RamlActionType.POST);
    }

    protected abstract boolean shouldAddMethodToApi(Method var1);

    protected Map<String, RamlQueryParameter> extractQueryParameters(RamlActionType apiAction, Method method, Map<String, String> parameterComments) {
        if (apiAction.equals((Object)RamlActionType.POST) || method.getParameterCount() == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, RamlQueryParameter> queryParams = new LinkedHashMap<String, RamlQueryParameter>();
        for (Parameter param : method.getParameters()) {
            if (!this.isQueryParameter(param)) continue;
            RamlParamType simpleType = SchemaHelper.mapSimpleType(param.getType());
            if (simpleType == null) {
                queryParams.putAll(SchemaHelper.convertClassToQueryParameters(param, this.javaDocs.getJavaDoc(param.getType())));
                continue;
            }
            String paramComment = parameterComments.get(param.getName());
            queryParams.putAll(SchemaHelper.convertParameterToQueryParameter(param, paramComment));
        }
        return queryParams;
    }

    protected abstract boolean isQueryParameter(Parameter var1);

    protected abstract List<ApiParameterMetadata> getApiParameters(Method var1, boolean var2, boolean var3);

    protected Map<String, RamlMimeType> extractRequestBodyFromMethod(RamlActionType apiAction, Method method, Map<String, String> parameterComments) {
        if (!ResourceParser.doesActionTypeSupportRequestBody(apiAction) || method.getParameterCount() == 0) {
            return Collections.emptyMap();
        }
        String comment = null;
        List<ApiParameterMetadata> apiParameters = this.getApiParameters(method, false, true);
        if (apiParameters.size() == 0) {
            return Collections.emptyMap();
        }
        Pair<String, RamlMimeType> schemaAndMime = this.extractRequestBody(method, parameterComments, comment, apiParameters);
        return Collections.singletonMap(schemaAndMime.getFirst(), schemaAndMime.getSecond());
    }

    protected Pair<String, RamlMimeType> extractRequestBody(Method method, Map<String, String> parameterComments, String comment, List<ApiParameterMetadata> apiParameters) {
        String schema;
        RamlMimeType mimeType = RamlModelFactoryOfFactories.createRamlModelFactory().createRamlMimeType();
        if (apiParameters.size() == 1) {
            if (parameterComments != null && parameterComments.size() == 1) {
                comment = parameterComments.values().iterator().next();
            }
            ApiParameterMetadata ajaxParameter = apiParameters.get(0);
            schema = SchemaHelper.convertClassToJsonSchema(ajaxParameter, comment, this.javaDocs.getJavaDoc(ajaxParameter.getType()));
            if (StringUtils.hasText((String)ajaxParameter.getExample())) {
                mimeType.setExample(ajaxParameter.getExample());
            }
        } else {
            schema = "{ \"type\": \"object\", \n \"properties\": {\n";
            boolean first = true;
            for (ApiParameterMetadata param : apiParameters) {
                if (!first) {
                    schema = schema + ",\n";
                } else {
                    first = false;
                }
                schema = schema + "\"" + param.getName() + "\" : ";
                comment = "";
                if (parameterComments != null && StringUtils.hasText((String)comment) && StringUtils.hasText((String)parameterComments.get(param.getJavaName()))) {
                    comment = parameterComments.get(param.getJavaName());
                }
                schema = schema + SchemaHelper.convertClassToJsonSchema(param, comment, this.javaDocs.getJavaDoc(param.getType()));
            }
            schema = schema + "}\n}";
        }
        mimeType.setSchema(schema);
        return new Pair<String, RamlMimeType>(this.extractExpectedMimeTypeFromMethod(method), mimeType);
    }

    protected abstract void addHeadersForMethod(RamlAction var1, RamlActionType var2, Method var3);

    protected abstract ApiParameterMetadata[] extractResourceIdParameter(Method var1);

    protected abstract Map<RamlActionType, String> getHttpMethodAndName(Class<?> var1, Method var2);

    protected abstract void extractAndAppendResourceInfo(Class<?> var1, Method var2, JavaDocEntry var3, RamlResource var4);

    protected abstract boolean isActionOnResourceWithoutCommand(Method var1);

    protected String extractMimeTypeFromMethod(Method method) {
        return this.defaultMediaType;
    }

    protected String extractExpectedMimeTypeFromMethod(Method method) {
        return this.defaultMediaType;
    }

    protected RamlResponse extractResponseFromMethod(Method method, String responseComment) {
        RamlModelFactory ramlModelFactory = RamlModelFactoryOfFactories.createRamlModelFactory();
        RamlResponse response = ramlModelFactory.createRamlResponse();
        String mime = this.extractMimeTypeFromMethod(method);
        RamlMimeType jsonType = ramlModelFactory.createRamlMimeTypeWithMime(mime);
        Class returnType = method.getReturnType();
        Object genericReturnType = method.getGenericReturnType();
        Object inferGenericType = TypeHelper.inferGenericType((Type)genericReturnType);
        if (returnType != null && (returnType.equals(DeferredResult.class) || returnType.equals(ResponseEntity.class))) {
            if (inferGenericType == null) {
                inferGenericType = Object.class;
            }
            if (inferGenericType instanceof Class) {
                returnType = (Class)inferGenericType;
            }
            genericReturnType = inferGenericType;
        }
        jsonType.setSchema(SchemaHelper.convertClassToJsonSchema((Type)genericReturnType, responseComment, this.javaDocs.getJavaDoc(returnType)));
        LinkedHashMap<String, RamlMimeType> body = new LinkedHashMap<String, RamlMimeType>();
        body.put(mime, jsonType);
        response.setBody(body);
        if (StringUtils.hasText((String)responseComment)) {
            response.setDescription(responseComment);
        } else {
            response.setDescription("Successful Response");
        }
        return response;
    }

    public RamlResource extractResourceInfo(Class<?> clazz) {
        logger.info("Parsing resource: " + clazz.getSimpleName() + " ");
        RamlResource resource = RamlModelFactoryOfFactories.createRamlModelFactory().createRamlResource();
        resource.setRelativeUri("/" + this.getResourceName(clazz));
        resource.setDisplayName(clazz.getSimpleName());
        JavaDocStore javaDoc = this.javaDocs.getJavaDoc(clazz);
        String comment = javaDoc.getJavaDocComment(clazz);
        if (comment != null) {
            resource.setDescription(comment);
        }
        this.getMethodsFromService(clazz, javaDoc, resource);
        return resource;
    }

    protected abstract String getResourceName(Class<?> var1);
}

