/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.raml.rjp.raml08v1;

import com.phoenixnap.oss.ramlapisync.raml.RamlAction;
import com.phoenixnap.oss.ramlapisync.raml.RamlActionType;
import com.phoenixnap.oss.ramlapisync.raml.RamlResource;
import com.phoenixnap.oss.ramlapisync.raml.RamlUriParameter;
import com.phoenixnap.oss.ramlapisync.raml.rjp.raml08v1.RJP08V1RamlModelFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.Resource;

public class RJP08V1RamlResource
implements RamlResource {
    private static RJP08V1RamlModelFactory ramlModelFactory = new RJP08V1RamlModelFactory();
    private final Resource resource;
    private Map<String, RamlResource> resources = new LinkedHashMap<String, RamlResource>();
    private Map<RamlActionType, RamlAction> actions = new LinkedHashMap<RamlActionType, RamlAction>();
    private Map<String, RamlUriParameter> uriParameters = new LinkedHashMap<String, RamlUriParameter>();
    private Map<String, RamlUriParameter> resolvedUriParameters = new LinkedHashMap<String, RamlUriParameter>();

    public RJP08V1RamlResource(Resource resource) {
        this.resource = resource;
    }

    Resource getResource() {
        return this.resource;
    }

    @Override
    public String getRelativeUri() {
        return this.resource.getRelativeUri();
    }

    @Override
    public void setRelativeUri(String relativeUri) {
        this.resource.setRelativeUri(relativeUri);
    }

    @Override
    public Map<RamlActionType, RamlAction> getActions() {
        return ramlModelFactory.transformToUnmodifiableMap(this.resource.getActions(), this.actions, ramlModelFactory::createRamlAction, ramlModelFactory::createRamlActionType);
    }

    @Override
    public void addActions(Map<RamlActionType, RamlAction> newActions) {
        for (RamlActionType key : newActions.keySet()) {
            this.addAction(key, newActions.get((Object)key));
        }
    }

    @Override
    public void addAction(RamlActionType actionType, RamlAction action) {
        this.resource.getActions().put(ramlModelFactory.extractActionType(actionType), ramlModelFactory.extractAction(action));
        this.actions.put(actionType, action);
    }

    @Override
    public void addResource(String path, RamlResource childResource) {
        this.resource.getResources().put(path, ramlModelFactory.extractResource(childResource));
        this.resources.put(path, childResource);
    }

    @Override
    public void removeResource(String firstResourcePart) {
        this.resource.getResources().remove(firstResourcePart);
        this.resources.remove(firstResourcePart);
    }

    @Override
    public void addResources(Map<String, RamlResource> resources) {
        for (String key : resources.keySet()) {
            this.addResource(key, resources.get(key));
        }
    }

    @Override
    public Map<String, RamlResource> getResources() {
        return ramlModelFactory.transformToUnmodifiableMap(this.resource.getResources(), this.resources, ramlModelFactory::createRamlResource);
    }

    @Override
    public RamlResource getResource(String path) {
        return ramlModelFactory.createRamlResource(this.resource.getResource(path));
    }

    @Override
    public Map<String, RamlUriParameter> getUriParameters() {
        return ramlModelFactory.transformToUnmodifiableMap(this.resource.getUriParameters(), this.uriParameters, ramlModelFactory::createRamlUriParameter);
    }

    @Override
    public void addUriParameter(String name, RamlUriParameter uriParameter) {
        this.uriParameters.put(name, uriParameter);
        this.resource.getUriParameters().put(name, ramlModelFactory.extractUriParameter(uriParameter));
    }

    @Override
    public Map<String, RamlUriParameter> getResolvedUriParameters() {
        return ramlModelFactory.transformToUnmodifiableMap(this.resource.getResolvedUriParameters(), this.resolvedUriParameters, ramlModelFactory::createRamlUriParameter);
    }

    @Override
    public String getUri() {
        return this.resource.getUri();
    }

    @Override
    public String getDescription() {
        return this.resource.getDescription();
    }

    @Override
    public RamlResource getParentResource() {
        return ramlModelFactory.createRamlResource(this.resource.getParentResource());
    }

    @Override
    public String getParentUri() {
        return this.resource.getParentUri();
    }

    @Override
    public void setParentUri(String parentUri) {
        this.resource.setParentUri(parentUri);
    }

    @Override
    public void setParentResource(RamlResource parentResource) {
        this.resource.setParentResource(ramlModelFactory.extractResource(parentResource));
    }

    @Override
    public void setDisplayName(String displayName) {
        this.resource.setDisplayName(displayName);
    }

    @Override
    public void setDescription(String description) {
        this.resource.setDescription(description);
    }

    @Override
    public RamlAction getAction(RamlActionType actionType) {
        ActionType name = ramlModelFactory.extractActionType(actionType);
        Action action = this.resource.getAction(name);
        return ramlModelFactory.createRamlAction(action);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RamlResource)) {
            return false;
        }
        RamlResource resource = (RamlResource)o;
        return this.getParentUri().equals(resource.getParentUri()) && this.getRelativeUri().equals(resource.getRelativeUri());
    }

    public int hashCode() {
        return this.resource.hashCode();
    }
}

