/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.style;

import com.phoenixnap.oss.ramlapisync.naming.Pair;
import com.phoenixnap.oss.ramlapisync.raml.RamlAction;
import com.phoenixnap.oss.ramlapisync.raml.RamlActionType;
import com.phoenixnap.oss.ramlapisync.raml.RamlQueryParameter;
import com.phoenixnap.oss.ramlapisync.raml.RamlResource;
import com.phoenixnap.oss.ramlapisync.raml.RamlRoot;
import com.phoenixnap.oss.ramlapisync.raml.RamlUriParameter;
import com.phoenixnap.oss.ramlapisync.style.RamlStyleChecker;
import com.phoenixnap.oss.ramlapisync.verification.Issue;
import com.phoenixnap.oss.ramlapisync.verification.IssueLocation;
import com.phoenixnap.oss.ramlapisync.verification.IssueSeverity;
import com.phoenixnap.oss.ramlapisync.verification.IssueType;
import com.phoenixnap.oss.ramlapisync.verification.RamlChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RamlStyleCheckVisitorCoordinator
implements RamlChecker {
    private boolean ignoreCodeStyle = true;
    private Set<Issue> warnings = new LinkedHashSet<Issue>();
    private List<RamlStyleChecker> checkers = new ArrayList<RamlStyleChecker>();

    public RamlStyleCheckVisitorCoordinator(List<RamlStyleChecker> styleChecks) {
        this.checkers.addAll(styleChecks);
    }

    @Override
    public Pair<Set<Issue>, Set<Issue>> check(RamlRoot published, RamlRoot implemented) {
        this.checkChildren(published.getResources(), published, IssueLocation.CONTRACT);
        if (!this.ignoreCodeStyle && implemented != null) {
            this.checkChildren(implemented.getResources(), implemented, IssueLocation.SOURCE);
        }
        return new Pair<Set<Issue>, Set<Issue>>(this.warnings, Collections.emptySet());
    }

    private void checkChildren(Map<String, RamlResource> resources, RamlRoot raml, IssueLocation location) {
        if (resources != null) {
            for (Map.Entry<String, RamlResource> entry : resources.entrySet()) {
                Map<RamlActionType, RamlAction> map;
                RamlResource resource = entry.getValue();
                for (RamlStyleChecker ramlStyleChecker : this.checkers) {
                    this.warnings.addAll(ramlStyleChecker.checkResourceStyle(entry.getKey(), resource, location, raml));
                }
                Map<String, RamlUriParameter> uriParameters = resource.getUriParameters();
                if (uriParameters != null) {
                    for (Map.Entry<String, RamlUriParameter> uriParameter : uriParameters.entrySet()) {
                        for (RamlStyleChecker ramlStyleChecker : this.checkers) {
                            this.warnings.addAll(ramlStyleChecker.checkParameterStyle(uriParameter.getKey(), uriParameter.getValue()));
                        }
                    }
                }
                if ((map = resource.getActions()) != null) {
                    for (Map.Entry<RamlActionType, RamlAction> actionEntry : map.entrySet()) {
                        for (RamlStyleChecker checker : this.checkers) {
                            this.warnings.addAll(checker.checkActionStyle(actionEntry.getKey(), actionEntry.getValue(), location, raml));
                        }
                        Map<String, RamlQueryParameter> map2 = actionEntry.getValue().getQueryParameters();
                        if (map2 == null) continue;
                        for (Map.Entry<String, RamlQueryParameter> queryParam : map2.entrySet()) {
                            for (RamlStyleChecker checker : this.checkers) {
                                this.warnings.addAll(checker.checkParameterStyle(queryParam.getKey(), queryParam.getValue()));
                            }
                        }
                    }
                }
                this.checkChildren(resource.getResources(), raml, location);
            }
        }
    }

    protected final void addIssue(IssueLocation location, String description, String ramlLocation) {
        this.warnings.add(new Issue(IssueSeverity.WARNING, location, IssueType.STYLE, description, ramlLocation));
    }
}

