/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.style.checkers;

import com.phoenixnap.oss.ramlapisync.naming.SchemaHelper;
import com.phoenixnap.oss.ramlapisync.raml.RamlAction;
import com.phoenixnap.oss.ramlapisync.raml.RamlActionType;
import com.phoenixnap.oss.ramlapisync.raml.RamlMimeType;
import com.phoenixnap.oss.ramlapisync.raml.RamlRoot;
import com.phoenixnap.oss.ramlapisync.style.RamlStyleCheckerAdapter;
import com.phoenixnap.oss.ramlapisync.style.StyleIssue;
import com.phoenixnap.oss.ramlapisync.style.checkers.ResponseBodySchemaStyleChecker;
import com.phoenixnap.oss.ramlapisync.verification.IssueLocation;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RequestBodySchemaStyleChecker
extends RamlStyleCheckerAdapter {
    protected static final Logger logger = LoggerFactory.getLogger(ResponseBodySchemaStyleChecker.class);
    public static String DESCRIPTION = "Action %s should define response body schema";
    private Set<String> actionsToEnforce = new LinkedHashSet<String>();

    public RequestBodySchemaStyleChecker(String actionTypesToCheck) {
        String[] tokens;
        for (String token : tokens = StringUtils.delimitedListToStringArray((String)actionTypesToCheck, (String)",", (String)" ")) {
            this.actionsToEnforce.add(token);
        }
    }

    @Override
    public Set<StyleIssue> checkActionStyle(RamlActionType key, RamlAction value, IssueLocation location, RamlRoot raml) {
        logger.debug("Checking Action: " + (Object)((Object)key));
        LinkedHashSet<StyleIssue> issues = new LinkedHashSet<StyleIssue>();
        if (this.actionsToEnforce.contains(key.name())) {
            Map<String, RamlMimeType> successResponse;
            boolean schemaFound = false;
            if (value.hasBody() && SchemaHelper.containsBodySchema(successResponse = value.getBody(), raml, true)) {
                schemaFound = true;
            }
            if (!schemaFound) {
                issues.add(new StyleIssue(location, String.format(DESCRIPTION, new Object[]{key}), value.getResource(), value));
            }
        }
        return issues;
    }
}

