/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.style.checkers;

import com.phoenixnap.oss.ramlapisync.raml.RamlActionType;
import com.phoenixnap.oss.ramlapisync.raml.RamlResource;
import com.phoenixnap.oss.ramlapisync.raml.RamlRoot;
import com.phoenixnap.oss.ramlapisync.style.RamlStyleCheckerAdapter;
import com.phoenixnap.oss.ramlapisync.style.StyleIssue;
import com.phoenixnap.oss.ramlapisync.verification.IssueLocation;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.raml.parser.utils.Inflector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceCollectionPluralisationChecker
extends RamlStyleCheckerAdapter {
    protected static final Logger logger = LoggerFactory.getLogger(ResourceCollectionPluralisationChecker.class);
    public static String DESCRIPTION = "Collections of Resources should be Pluralised in the URL";
    public static String ID_RESOURCE_REGEX = "[/]{0,1}\\{([^\\}]*)\\}";
    private static Pattern ID_RESOURCE_PATTERN = Pattern.compile(ID_RESOURCE_REGEX);

    @Override
    public Set<StyleIssue> checkResourceStyle(String name, RamlResource resource, IssueLocation location, RamlRoot raml) {
        logger.debug("Checking resource " + name);
        LinkedHashSet<StyleIssue> issues = new LinkedHashSet<StyleIssue>();
        if (ID_RESOURCE_PATTERN.matcher(name).find() || "/".equals(name)) {
            return issues;
        }
        boolean hasIdSubresource = false;
        boolean hasVerb = false;
        for (Map.Entry<String, RamlResource> subResourceEntry : resource.getResources().entrySet()) {
            RamlResource subResource;
            if (ID_RESOURCE_PATTERN.matcher(subResourceEntry.getKey()).find()) {
                hasIdSubresource = true;
            }
            if ((subResource = subResourceEntry.getValue()) != null && (subResource.getAction(RamlActionType.POST) != null || subResource.getAction(RamlActionType.GET) != null)) {
                hasVerb = true;
            }
            if (!hasIdSubresource || !hasVerb) continue;
            logger.debug("Collection Resource identified: " + name);
            if (!Inflector.singularize((String)name).equals(name) || Inflector.pluralize((String)name).equals(name)) break;
            issues.add(new StyleIssue(location, DESCRIPTION, resource, null));
            break;
        }
        return issues;
    }
}

