/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.style.checkers;

import com.phoenixnap.oss.ramlapisync.naming.SchemaHelper;
import com.phoenixnap.oss.ramlapisync.raml.RamlAction;
import com.phoenixnap.oss.ramlapisync.raml.RamlActionType;
import com.phoenixnap.oss.ramlapisync.raml.RamlMimeType;
import com.phoenixnap.oss.ramlapisync.raml.RamlRoot;
import com.phoenixnap.oss.ramlapisync.style.RamlStyleCheckerAdapter;
import com.phoenixnap.oss.ramlapisync.style.StyleIssue;
import com.phoenixnap.oss.ramlapisync.verification.IssueLocation;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ResponseBodySchemaStyleChecker
extends RamlStyleCheckerAdapter {
    protected static final Logger logger = LoggerFactory.getLogger(ResponseBodySchemaStyleChecker.class);
    public static String DESCRIPTION = "Action %s should define response body schema";
    private Set<String> actionsToEnforce = new LinkedHashSet<String>();

    public ResponseBodySchemaStyleChecker(String actionTypesToCheck) {
        String[] tokens;
        for (String token : tokens = StringUtils.delimitedListToStringArray((String)actionTypesToCheck, (String)",", (String)" ")) {
            this.actionsToEnforce.add(token);
        }
    }

    @Override
    public Set<StyleIssue> checkActionStyle(RamlActionType key, RamlAction value, IssueLocation location, RamlRoot raml) {
        logger.debug("Checking Action: " + (Object)((Object)key));
        LinkedHashSet<StyleIssue> issues = new LinkedHashSet<StyleIssue>();
        if (this.actionsToEnforce.contains(key.name())) {
            boolean schemaFound = false;
            if (value.getResponses() != null && !value.getResponses().isEmpty()) {
                Map<String, RamlMimeType> createdResponse;
                Map<String, RamlMimeType> successResponse;
                if (value.getResponses().containsKey("200") && value.getResponses().get("200").getBody() != null && SchemaHelper.containsBodySchema(successResponse = value.getResponses().get("200").getBody(), raml, true)) {
                    schemaFound = true;
                }
                if (value.getResponses().containsKey("201") && value.getResponses().get("201").getBody() != null && SchemaHelper.containsBodySchema(createdResponse = value.getResponses().get("201").getBody(), raml, true)) {
                    schemaFound = true;
                }
            }
            if (!schemaFound) {
                issues.add(new StyleIssue(location, String.format(DESCRIPTION, new Object[]{key}), value.getResource(), value));
            }
        }
        return issues;
    }
}

