/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.style.checkers;

import com.phoenixnap.oss.ramlapisync.raml.RamlAction;
import com.phoenixnap.oss.ramlapisync.raml.RamlActionType;
import com.phoenixnap.oss.ramlapisync.raml.RamlRoot;
import com.phoenixnap.oss.ramlapisync.style.RamlStyleCheckerAdapter;
import com.phoenixnap.oss.ramlapisync.style.StyleIssue;
import com.phoenixnap.oss.ramlapisync.verification.IssueLocation;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;

public class ResponseCodeDefinitionStyleChecker
extends RamlStyleCheckerAdapter {
    protected static final Logger logger = LoggerFactory.getLogger(ResponseCodeDefinitionStyleChecker.class);
    public static String DESCRIPTION = "%s Verb should define %s (%d) response";
    private MultiValueMap<String, HttpStatus> statusChecks;

    public ResponseCodeDefinitionStyleChecker(MultiValueMap<String, HttpStatus> statusChecks) {
        this.statusChecks = statusChecks;
    }

    @Override
    public Set<StyleIssue> checkActionStyle(RamlActionType key, RamlAction value, IssueLocation location, RamlRoot raml) {
        List statuses;
        logger.debug("Checking Action: " + (Object)((Object)key));
        LinkedHashSet<StyleIssue> issues = new LinkedHashSet<StyleIssue>();
        if (this.statusChecks.containsKey((Object)key.name()) && !CollectionUtils.isEmpty((Collection)(statuses = (List)this.statusChecks.get((Object)key.name())))) {
            for (HttpStatus check : statuses) {
                if (value.getResponses() != null && value.getResponses().containsKey(String.valueOf(check.value()))) continue;
                issues.add(new StyleIssue(location, String.format(DESCRIPTION, new Object[]{key, check.name(), check.value()}), value.getResource(), value));
            }
        }
        return issues;
    }
}

