/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.verification;

import com.phoenixnap.oss.ramlapisync.raml.RamlAction;
import com.phoenixnap.oss.ramlapisync.raml.RamlResource;
import com.phoenixnap.oss.ramlapisync.verification.IssueLocation;
import com.phoenixnap.oss.ramlapisync.verification.IssueSeverity;
import com.phoenixnap.oss.ramlapisync.verification.IssueType;
import org.springframework.util.StringUtils;

public class Issue {
    private IssueSeverity severity;
    private IssueLocation location;
    private IssueType type;
    private String description;
    private String ramlLocation;
    private RamlResource resourceLocation;
    private RamlAction action;
    private String parameter;

    public Issue(IssueSeverity severity, IssueLocation location, IssueType type, String description, RamlResource resource, RamlAction action, String parameter) {
        this.severity = severity;
        this.location = location;
        this.type = type;
        this.description = description;
        this.resourceLocation = resource;
        this.action = action;
        this.parameter = parameter;
    }

    public Issue(IssueSeverity severity, IssueLocation location, IssueType type, String description, RamlResource resource, RamlAction action) {
        this(severity, location, type, description, resource, action, null);
    }

    public Issue(IssueSeverity severity, IssueLocation location, IssueType type, String description, String ramlLocation) {
        this.severity = severity;
        this.type = type;
        this.location = location;
        this.description = description;
        this.ramlLocation = ramlLocation;
        this.resourceLocation = null;
        this.action = null;
        this.parameter = null;
    }

    public static String buildRamlLocation(RamlResource resource, RamlAction action, String parameter) {
        String outLocation = resource.getUri();
        if (action != null && action.getType() != null) {
            outLocation = action.getType().name() + " " + outLocation;
        }
        if (StringUtils.hasText((String)parameter)) {
            outLocation = parameter + " : " + outLocation;
        }
        return outLocation;
    }

    public IssueType getType() {
        return this.type;
    }

    public IssueSeverity getSeverity() {
        return this.severity;
    }

    public IssueLocation getLocation() {
        return this.location;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRamlLocation() {
        if (this.ramlLocation == null) {
            this.ramlLocation = Issue.buildRamlLocation(this.resourceLocation, this.action, this.parameter);
        }
        return this.ramlLocation;
    }

    public RamlResource getResourceLocation() {
        return this.resourceLocation;
    }

    public RamlAction getAction() {
        return this.action;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        String ramlLocation = this.getRamlLocation();
        result = 31 * result + (ramlLocation == null ? 0 : ramlLocation.hashCode());
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!Issue.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        Issue other = (Issue)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.location != other.location) {
            return false;
        }
        String ramlLocation = this.getRamlLocation();
        String otherRamlLocation = other.getRamlLocation();
        if (ramlLocation == null ? otherRamlLocation != null : !ramlLocation.equals(otherRamlLocation)) {
            return false;
        }
        if (this.severity != other.severity) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return "Issue [severity=" + (Object)((Object)this.severity) + ", location=" + (Object)((Object)this.location) + ", type=" + (Object)((Object)this.type) + ", description=" + this.description + ", ramlLocation=" + this.getRamlLocation() + "]";
    }
}

