/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.verification.checkers;

import com.phoenixnap.oss.ramlapisync.naming.Pair;
import com.phoenixnap.oss.ramlapisync.raml.RamlAction;
import com.phoenixnap.oss.ramlapisync.raml.RamlActionType;
import com.phoenixnap.oss.ramlapisync.raml.RamlResource;
import com.phoenixnap.oss.ramlapisync.verification.Issue;
import com.phoenixnap.oss.ramlapisync.verification.IssueLocation;
import com.phoenixnap.oss.ramlapisync.verification.IssueSeverity;
import com.phoenixnap.oss.ramlapisync.verification.IssueType;
import com.phoenixnap.oss.ramlapisync.verification.RamlResourceVisitorCheck;
import com.phoenixnap.oss.ramlapisync.verification.checkers.RamlCheckerResourceVisitorCoordinator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionExistenceChecker
implements RamlResourceVisitorCheck {
    public static String ACTION_MISSING = "Missing Action.";
    protected static final Logger logger = LoggerFactory.getLogger(ActionExistenceChecker.class);

    @Override
    public Pair<Set<Issue>, Set<Issue>> check(String name, RamlResource reference, RamlResource target, IssueLocation location, IssueSeverity maxSeverity) {
        logger.debug("Checking Action " + name);
        LinkedHashSet<Issue> errors = new LinkedHashSet<Issue>();
        LinkedHashSet<Issue> warnings = new LinkedHashSet<Issue>();
        Map<RamlActionType, RamlAction> referenceActions = reference.getActions();
        Map<RamlActionType, RamlAction> targetActions = target.getActions();
        if (referenceActions != null && referenceActions.size() > 0) {
            for (Map.Entry<RamlActionType, RamlAction> action : referenceActions.entrySet()) {
                RamlAction targetAction = targetActions.get((Object)action.getKey());
                if (targetAction != null) continue;
                Issue issue = new Issue(maxSeverity, location, IssueType.MISSING, ACTION_MISSING, reference, action.getValue());
                RamlCheckerResourceVisitorCoordinator.addIssue(errors, warnings, issue, "Expected action missing: " + (Object)((Object)action.getKey()) + " in " + location.name());
            }
        }
        return new Pair<Set<Issue>, Set<Issue>>(warnings, errors);
    }
}

