/*
 * Decompiled with CFR 0.152.
 */
package com.phoenixnap.oss.ramlapisync.verification.checkers;

import com.phoenixnap.oss.ramlapisync.naming.NamingHelper;
import com.phoenixnap.oss.ramlapisync.naming.Pair;
import com.phoenixnap.oss.ramlapisync.raml.RamlResource;
import com.phoenixnap.oss.ramlapisync.raml.RamlRoot;
import com.phoenixnap.oss.ramlapisync.verification.Issue;
import com.phoenixnap.oss.ramlapisync.verification.IssueLocation;
import com.phoenixnap.oss.ramlapisync.verification.IssueSeverity;
import com.phoenixnap.oss.ramlapisync.verification.IssueType;
import com.phoenixnap.oss.ramlapisync.verification.RamlChecker;
import com.phoenixnap.oss.ramlapisync.verification.checkers.RamlCheckerResourceVisitorCoordinator;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceExistenceChecker
implements RamlChecker {
    public static String RESOURCE_MISSING = "Missing Resource.";
    public static String CONTRACT_MISSING = "Completely Missing RAML file";
    public static String IMPLEMENTATION_MISSING = "Completely Missing Implementation for RAML file";
    public static String RESOURCE_WITH_DISCREPANCY = "Resource declared with case, spacing or special character differences.";
    protected static final Logger logger = LoggerFactory.getLogger(ResourceExistenceChecker.class);
    private Set<Issue> errors = new LinkedHashSet<Issue>();
    private Set<Issue> warnings = new LinkedHashSet<Issue>();

    @Override
    public Pair<Set<Issue>, Set<Issue>> check(RamlRoot published, RamlRoot implemented) {
        logger.info("Performing Resource Existence Checks");
        if (published != null && implemented == null) {
            this.errors.add(new Issue(IssueSeverity.ERROR, IssueLocation.CONTRACT, IssueType.MISSING, IMPLEMENTATION_MISSING, "/"));
        } else if (published == null && implemented != null) {
            this.errors.add(new Issue(IssueSeverity.ERROR, IssueLocation.SOURCE, IssueType.MISSING, CONTRACT_MISSING, "/"));
        } else {
            logger.debug("Checking for any missing resources in implementation");
            this.check(published.getResources(), implemented.getResources(), IssueLocation.SOURCE, IssueSeverity.ERROR, false);
            logger.debug("Checking for any missing resources in RAML");
            this.check(implemented.getResources(), published.getResources(), IssueLocation.CONTRACT, IssueSeverity.WARNING, false);
        }
        return new Pair<Set<Issue>, Set<Issue>>(this.warnings, this.errors);
    }

    private void check(Map<String, RamlResource> referenceResourcesMap, Map<String, RamlResource> targetResourcesMap, IssueLocation location, IssueSeverity severity, boolean exact) {
        Set<Object> referenceResources = referenceResourcesMap != null ? referenceResourcesMap.keySet() : Collections.emptySet();
        Set<Object> targetResources = targetResourcesMap != null ? targetResourcesMap.keySet() : Collections.emptySet();
        Map<String, RamlResource> implementedCleanedResources = this.clean(targetResourcesMap);
        for (String string : referenceResources) {
            if (targetResources.contains(string)) {
                logger.debug("Expecting and found resource: " + string);
                this.check(referenceResourcesMap.get(string).getResources(), targetResourcesMap.get(string).getResources(), location, severity, exact);
                continue;
            }
            String cleanedResource = this.clean(string);
            if (implementedCleanedResources.keySet().contains(cleanedResource) && !exact) {
                logger.debug("Expecting resource " + string + " and found with minor differences: " + cleanedResource);
                this.warnings.add(new Issue(IssueSeverity.WARNING, location, IssueType.MISSING, RESOURCE_WITH_DISCREPANCY, referenceResourcesMap.get(string), null));
                this.check(referenceResourcesMap.get(string).getResources(), implementedCleanedResources.get(cleanedResource).getResources(), location, severity, exact);
                continue;
            }
            boolean foundAlternateUriParam = false;
            if (NamingHelper.isUriParamResource(string)) {
                for (String string2 : targetResources) {
                    if (!NamingHelper.isUriParamResource(string2)) continue;
                    foundAlternateUriParam = true;
                }
            }
            Issue issue = new Issue(foundAlternateUriParam ? IssueSeverity.WARNING : severity, location, IssueType.MISSING, RESOURCE_MISSING, referenceResourcesMap.get(string), null);
            RamlCheckerResourceVisitorCoordinator.addIssue(this.errors, this.warnings, issue, "Expected resource missing: " + string + " in " + location.name());
        }
    }

    private Map<String, RamlResource> clean(Map<String, RamlResource> publishedResources) {
        HashMap<String, RamlResource> cleanedSet = new HashMap<String, RamlResource>();
        if (publishedResources == null) {
            return cleanedSet;
        }
        for (Map.Entry<String, RamlResource> resource : publishedResources.entrySet()) {
            cleanedSet.put(this.clean(resource.getKey()), resource.getValue());
        }
        return cleanedSet;
    }

    private String clean(String resource) {
        if (resource == null) {
            return null;
        }
        return NamingHelper.cleanLeadingAndTrailingNewLineAndChars(resource.toLowerCase());
    }
}

