/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal;

import com.pholser.junit.quickcheck.internal.Weighted;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.util.Collection;

public final class Items {
    private Items() {
        throw new UnsupportedOperationException();
    }

    public static <T> T choose(Collection<T> items, SourceOfRandomness random) {
        Object[] asArray = items.toArray(new Object[items.size()]);
        return (T)asArray[random.nextInt(items.size())];
    }

    public static <T> T chooseWeighted(Collection<Weighted<T>> items, SourceOfRandomness random) {
        if (items.size() == 1) {
            return items.iterator().next().item;
        }
        int range = items.stream().mapToInt(i -> i.weight).sum();
        int sample = random.nextInt(range);
        int threshold = 0;
        for (Weighted<T> each : items) {
            if (sample >= (threshold += each.weight)) continue;
            return each.item;
        }
        throw new AssertionError((Object)String.format("sample = %d, range = %d", sample, range));
    }
}

