/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal;

import com.pholser.junit.quickcheck.generator.Shrink;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class Lists {
    private Lists() {
        throw new UnsupportedOperationException();
    }

    public static <T> List<List<T>> removeFrom(List<T> target, int howMany) {
        if (howMany < 0) {
            throw new IllegalArgumentException("Can't remove " + howMany + " elements from a list");
        }
        if (howMany == 0) {
            return Collections.singletonList(target);
        }
        if (howMany > target.size()) {
            return Collections.emptyList();
        }
        List left = target.subList(0, howMany);
        List<T> right = target.subList(howMany, target.size());
        if (right.isEmpty()) {
            return Collections.singletonList(Collections.emptyList());
        }
        ArrayList<List<T>> removals = new ArrayList<List<T>>();
        removals.add(right);
        removals.addAll(Lists.removeFrom(right, howMany).stream().map(r -> {
            ArrayList items = new ArrayList(left);
            items.addAll(r);
            return items;
        }).collect(Collectors.toList()));
        return removals;
    }

    public static <T> List<List<T>> shrinksOfOneItem(SourceOfRandomness random, List<T> target, Shrink<T> shrink) {
        if (target.isEmpty()) {
            return new ArrayList<List<T>>();
        }
        Object head = target.get(0);
        List tail = target.subList(1, target.size());
        ArrayList<List<T>> shrinks = new ArrayList<List<T>>();
        shrinks.addAll(shrink.shrink(random, head).stream().map(i -> {
            ArrayList<Object> items = new ArrayList<Object>();
            items.add(i);
            items.addAll(tail);
            return items;
        }).collect(Collectors.toList()));
        shrinks.addAll(Lists.shrinksOfOneItem(random, tail, shrink).stream().map(s -> {
            ArrayList<Object> items = new ArrayList<Object>();
            items.add(head);
            items.addAll((Collection<Object>)s);
            return items;
        }).collect(Collectors.toList()));
        return shrinks;
    }
}

