/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class Sequences {
    private Sequences() {
        throw new UnsupportedOperationException();
    }

    public static Iterable<BigInteger> halvingIntegral(final BigInteger max, final BigInteger start) {
        return () -> new Iterator<BigInteger>(){
            private boolean done;
            private BigInteger next;
            {
                this.next = start;
            }

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public BigInteger next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.next = this.peek();
                this.done = this.next.equals(this.peek());
                return this.next;
            }

            private BigInteger peek() {
                return this.next.add(max.subtract(this.next).divide(BigInteger.valueOf(2L)));
            }
        };
    }

    public static Iterable<BigDecimal> halvingDecimal(final BigDecimal max, final BigDecimal start) {
        return () -> new Iterator<BigDecimal>(){
            private boolean done;
            private BigDecimal next;
            {
                this.next = start;
            }

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public BigDecimal next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.next = this.peek();
                this.done = this.next.equals(this.peek());
                return this.next;
            }

            private BigDecimal peek() {
                return this.next.add(max.subtract(this.next).divide(BigDecimal.valueOf(2L), RoundingMode.HALF_UP));
            }
        };
    }

    public static Iterable<Integer> halving(final int start) {
        return () -> new Iterator<Integer>(){
            private boolean done;
            private int next;
            {
                this.next = start;
            }

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int result = this.next;
                this.next = this.peek();
                this.done = this.next == 0;
                return result;
            }

            private int peek() {
                return this.next / 2;
            }
        };
    }
}

