/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.runner;

import com.pholser.junit.quickcheck.MinimalCounterexampleHook;
import com.pholser.junit.quickcheck.Property;
import com.pholser.junit.quickcheck.internal.GeometricDistribution;
import com.pholser.junit.quickcheck.internal.ParameterTypeContext;
import com.pholser.junit.quickcheck.internal.PropertyParameterContext;
import com.pholser.junit.quickcheck.internal.ShrinkControl;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import com.pholser.junit.quickcheck.internal.generator.PropertyParameterGenerationContext;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import com.pholser.junit.quickcheck.runner.PropertyFalsified;
import com.pholser.junit.quickcheck.runner.PropertyVerifier;
import com.pholser.junit.quickcheck.runner.Shrinker;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.AssumptionViolatedException;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import ru.vyarus.java.generics.resolver.GenericsResolver;

class PropertyStatement
extends Statement {
    private final FrameworkMethod method;
    private final TestClass testClass;
    private final GeneratorRepository repo;
    private final GeometricDistribution distro;
    private final List<AssumptionViolatedException> assumptionViolations = new ArrayList<AssumptionViolatedException>();
    private int successes;

    PropertyStatement(FrameworkMethod method, TestClass testClass, GeneratorRepository repo, GeometricDistribution distro) {
        this.method = method;
        this.testClass = testClass;
        this.repo = repo;
        this.distro = distro;
    }

    public void evaluate() throws Throwable {
        Property marker = (Property)this.method.getAnnotation(Property.class);
        int trials = marker.trials();
        MinimalCounterexampleHook hook = marker.onMinimalCounterexample().newInstance();
        ShrinkControl shrinkControl = new ShrinkControl(marker.shrink(), marker.maxShrinks(), marker.maxShrinkDepth(), marker.maxShrinkTime(), hook);
        List<PropertyParameterGenerationContext> params = this.parameters(trials);
        for (int i = 0; i < trials; ++i) {
            this.verifyProperty(params, shrinkControl);
        }
        if (this.successes == 0 && !this.assumptionViolations.isEmpty()) {
            Assert.fail((String)("No values satisfied property assumptions. Violated assumptions: " + this.assumptionViolations));
        }
    }

    private void verifyProperty(List<PropertyParameterGenerationContext> params, ShrinkControl shrinkControl) throws Throwable {
        List<SeededValue> seededValues = this.argumentsFor(params);
        Object[] args = seededValues.stream().map(SeededValue::value).toArray();
        long[] seeds = seededValues.stream().mapToLong(SeededValue::seed).toArray();
        this.property(params, args, seeds, shrinkControl).verify();
    }

    private PropertyVerifier property(List<PropertyParameterGenerationContext> params, Object[] args, long[] seeds, ShrinkControl shrinkControl) throws InitializationError {
        return new PropertyVerifier(this.testClass, this.method, args, seeds, s -> ++this.successes, this.assumptionViolations::add, (e, action) -> {
            if (!shrinkControl.shouldShrink()) {
                shrinkControl.onMinimalCounterexample().handle(args, (Runnable)action);
                throw PropertyFalsified.counterexampleFound(this.method.getName(), args, seeds, e);
            }
            try {
                this.shrink(params, args, seeds, shrinkControl, (AssertionError)e);
            }
            catch (AssertionError ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new AssertionError((Object)ex.getCause());
            }
        });
    }

    private void shrink(List<PropertyParameterGenerationContext> params, Object[] args, long[] seeds, ShrinkControl shrinkControl, AssertionError failure) throws Throwable {
        new Shrinker(this.method, this.testClass, failure, shrinkControl.maxShrinks(), shrinkControl.maxShrinkDepth(), shrinkControl.maxShrinkTime(), shrinkControl.onMinimalCounterexample()).shrink(params, args, seeds);
    }

    private List<PropertyParameterGenerationContext> parameters(int trials) {
        Map typeVariables = GenericsResolver.resolve((Class)this.testClass.getJavaClass(), (Class[])new Class[0]).method(this.method.getMethod()).genericsMap();
        return Arrays.stream(this.method.getMethod().getParameters()).map(p -> this.parameterContextFor((Parameter)p, trials, typeVariables)).map(p -> new PropertyParameterGenerationContext((PropertyParameterContext)p, this.repo, this.distro, new SourceOfRandomness(new Random()))).collect(Collectors.toList());
    }

    private PropertyParameterContext parameterContextFor(Parameter parameter, int trials, Map<String, Type> typeVariables) {
        return new PropertyParameterContext(new ParameterTypeContext(parameter.getName(), parameter.getAnnotatedType(), PropertyStatement.declarerName(parameter), typeVariables).allowMixedTypes(true), trials).annotate(parameter);
    }

    private static String declarerName(Parameter p) {
        Executable exec = p.getDeclaringExecutable();
        return exec.getDeclaringClass().getName() + '.' + exec.getName();
    }

    private List<SeededValue> argumentsFor(List<PropertyParameterGenerationContext> params) {
        return params.stream().map(p -> new SeededValue(p.generate(), p.effectiveSeed())).collect(Collectors.toList());
    }

    private static final class SeededValue {
        private final Object value;
        private final long seed;

        SeededValue(Object value, long seed) {
            this.value = value;
            this.seed = seed;
        }

        Object value() {
            return this.value;
        }

        long seed() {
            return this.seed;
        }
    }
}

