/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.runner;

import com.pholser.junit.quickcheck.MinimalCounterexampleHook;
import com.pholser.junit.quickcheck.internal.generator.PropertyParameterGenerationContext;
import com.pholser.junit.quickcheck.runner.ShrinkNode;
import java.util.List;
import java.util.Stack;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

class Shrinker {
    private final FrameworkMethod method;
    private final TestClass testClass;
    private final AssertionError failure;
    private final int maxShrinks;
    private final int maxShrinkDepth;
    private final int maxShrinkTime;
    private final MinimalCounterexampleHook onMinimalCounterexample;
    private int shrinkAttempts;
    private long shrinkTimeout;

    Shrinker(FrameworkMethod method, TestClass testClass, AssertionError failure, int maxShrinks, int maxShrinkDepth, int maxShrinkTime, MinimalCounterexampleHook onMinimalCounterexample) {
        this.method = method;
        this.testClass = testClass;
        this.failure = failure;
        this.maxShrinks = maxShrinks;
        this.maxShrinkDepth = maxShrinkDepth;
        this.maxShrinkTime = maxShrinkTime;
        this.onMinimalCounterexample = onMinimalCounterexample;
    }

    void shrink(List<PropertyParameterGenerationContext> params, Object[] args, long[] seeds) throws Throwable {
        Stack<ShrinkNode> nodes = new Stack<ShrinkNode>();
        ShrinkNode counterexample = ShrinkNode.root(this.method, this.testClass, params, args, seeds, this.failure);
        counterexample.shrinks().forEach(nodes::push);
        this.shrinkTimeout = System.currentTimeMillis() + (long)this.maxShrinkTime;
        while (this.shouldContinueShrinking(nodes)) {
            ShrinkNode next = nodes.pop();
            if (!next.mightBePast(counterexample)) continue;
            boolean result = next.verifyProperty();
            ++this.shrinkAttempts;
            if (!result) {
                counterexample = next;
                List<ShrinkNode> shrinks = next.shrinks();
                if (shrinks.isEmpty()) {
                    counterexample = counterexample.advanceToNextArg();
                } else {
                    shrinks.forEach(nodes::push);
                }
            }
            if (!nodes.empty()) continue;
            counterexample = counterexample.advanceToNextArg();
            counterexample.shrinks().forEach(nodes::push);
        }
        this.handleMinimalCounterexample(counterexample);
        throw counterexample.fail(this.failure, args);
    }

    private void handleMinimalCounterexample(ShrinkNode counterexample) {
        Runnable repeat = () -> {
            try {
                counterexample.verifyProperty();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        };
        this.onMinimalCounterexample.handle(counterexample.getArgs(), repeat);
    }

    private boolean shouldContinueShrinking(Stack<ShrinkNode> nodes) {
        return this.shrinkAttempts < this.maxShrinks && this.shrinkTimeout >= System.currentTimeMillis() && !nodes.empty() && !nodes.peek().deeperThan(this.maxShrinkDepth);
    }
}

