/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.runner;

import com.pholser.junit.quickcheck.MinimalCounterexampleHook;
import com.pholser.junit.quickcheck.internal.ShrinkControl;
import com.pholser.junit.quickcheck.internal.generator.PropertyParameterGenerationContext;
import com.pholser.junit.quickcheck.runner.ShrinkNode;
import com.pholser.junit.quickcheck.runner.ShrinkNodeQueue;
import java.util.List;
import java.util.Queue;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

class Shrinker {
    private final FrameworkMethod method;
    private final TestClass testClass;
    private final AssertionError failure;
    private final int maxShrinks;
    private final int maxShrinkDepth;
    private final int maxShrinkTime;
    private final MinimalCounterexampleHook onMinimalCounterexample;
    private int shrinkAttempts;
    private long shrinkTimeout;

    Shrinker(FrameworkMethod method, TestClass testClass, AssertionError failure, ShrinkControl shrinkControl) {
        this.method = method;
        this.testClass = testClass;
        this.failure = failure;
        this.maxShrinks = shrinkControl.maxShrinks();
        this.maxShrinkDepth = shrinkControl.maxShrinkDepth() * method.getMethod().getParameterCount();
        this.maxShrinkTime = shrinkControl.maxShrinkTime();
        this.onMinimalCounterexample = shrinkControl.onMinimalCounterexample();
    }

    void shrink(List<PropertyParameterGenerationContext> params, Object[] args, long[] seeds) throws Throwable {
        ShrinkNode smallest = ShrinkNode.root(this.method, this.testClass, params, args, seeds, this.failure);
        ShrinkNodeQueue nodes = new ShrinkNodeQueue(smallest.magnitude());
        nodes.addAll(smallest.shrinks());
        this.shrinkTimeout = System.currentTimeMillis() + (long)this.maxShrinkTime;
        while (this.shouldContinueShrinking(nodes)) {
            ShrinkNode next = (ShrinkNode)nodes.poll();
            boolean result = next.verifyProperty();
            ++this.shrinkAttempts;
            if (result) continue;
            smallest = next;
            nodes.addAll(smallest.shrinks());
        }
        this.handleMinimalCounterexample(smallest);
        throw smallest.fail(this.failure, args);
    }

    private void handleMinimalCounterexample(ShrinkNode counterexample) {
        Runnable repeat = () -> {
            try {
                counterexample.verifyProperty();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        };
        this.onMinimalCounterexample.handle(counterexample.args(), repeat);
    }

    private boolean shouldContinueShrinking(Queue<ShrinkNode> nodes) {
        return this.shrinkAttempts < this.maxShrinks && this.shrinkTimeout >= System.currentTimeMillis() && !nodes.isEmpty() && nodes.peek().depth() <= this.maxShrinkDepth;
    }
}

