/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal.generator;

import com.pholser.junit.quickcheck.generator.Ctor;
import com.pholser.junit.quickcheck.generator.Fields;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.Generators;
import com.pholser.junit.quickcheck.internal.Items;
import com.pholser.junit.quickcheck.internal.ParameterTypeContext;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.Weighted;
import com.pholser.junit.quickcheck.internal.Zilch;
import com.pholser.junit.quickcheck.internal.generator.ArrayGenerator;
import com.pholser.junit.quickcheck.internal.generator.CompositeGenerator;
import com.pholser.junit.quickcheck.internal.generator.EnumGenerator;
import com.pholser.junit.quickcheck.internal.generator.LambdaGenerator;
import com.pholser.junit.quickcheck.internal.generator.NullAllowed;
import com.pholser.junit.quickcheck.internal.generator.NullableGenerator;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.javaruntype.type.TypeParameter;
import org.javaruntype.type.Types;

public class GeneratorRepository
implements Generators {
    private static final Set<String> NULLABLE_ANNOTATIONS = Collections.unmodifiableSet(Stream.of("javax.annotation.Nullable", NullAllowed.class.getCanonicalName()).collect(Collectors.toSet()));
    private final SourceOfRandomness random;
    private final Map<Class<?>, Set<Generator<?>>> generators;

    public GeneratorRepository(SourceOfRandomness random) {
        this(random, new HashMap());
    }

    private GeneratorRepository(SourceOfRandomness random, Map<Class<?>, Set<Generator<?>>> generators) {
        this.random = random;
        this.generators = generators;
    }

    public GeneratorRepository register(Generator<?> source) {
        this.registerTypes(source);
        return this;
    }

    public GeneratorRepository register(Iterable<Generator<?>> source) {
        for (Generator<?> each : source) {
            this.registerTypes(each);
        }
        return this;
    }

    private void registerTypes(Generator<?> generator) {
        for (Class<?> each : generator.types()) {
            this.registerHierarchy(each, generator);
        }
    }

    private void registerHierarchy(Class<?> type, Generator<?> generator) {
        this.maybeRegisterGeneratorForType(type, generator);
        if (type.getSuperclass() != null) {
            this.registerHierarchy(type.getSuperclass(), generator);
        } else if (type.isInterface()) {
            this.registerHierarchy(Object.class, generator);
        }
        for (Class<?> each : type.getInterfaces()) {
            this.registerHierarchy(each, generator);
        }
    }

    private void maybeRegisterGeneratorForType(Class<?> type, Generator<?> generator) {
        if (generator.canRegisterAsType(type)) {
            this.registerGeneratorForType(type, generator);
        }
    }

    private void registerGeneratorForType(Class<?> type, Generator<?> generator) {
        Set forType = this.generators.computeIfAbsent(type, k -> new LinkedHashSet());
        forType.add(generator);
    }

    @Override
    public Generator<?> field(Class<?> type, String fieldName) {
        return this.field(Reflection.findField(type, fieldName));
    }

    public <U> Generator<U> constructor(Class<U> type, Class<?> ... argumentTypes) {
        Constructor<U> constructor = Reflection.findConstructor(type, argumentTypes);
        Ctor<U> ctor = new Ctor<U>(constructor);
        ctor.provide(this);
        ctor.configure(constructor.getAnnotatedReturnType());
        return ctor;
    }

    public <U> Generator<U> fieldsOf(Class<U> type) {
        Fields<U> fields = new Fields<U>(type);
        fields.provide(this);
        fields.configure(type);
        return fields;
    }

    @Override
    public <T> Generator<T> type(Class<T> type, Class<?> ... componentTypes) {
        Generator<?> generator = this.produceGenerator(new ParameterTypeContext(type));
        generator.addComponentGenerators(Arrays.stream(componentTypes).map(c -> this.type((Class)c, new Class[0])).collect(Collectors.toList()));
        return generator;
    }

    @Override
    public Generator<?> parameter(Parameter parameter) {
        return this.produceGenerator(new ParameterTypeContext(parameter.getName(), parameter.getAnnotatedType(), parameter.getDeclaringExecutable().getName()).annotate(parameter));
    }

    @Override
    public Generator<?> field(Field field) {
        return this.produceGenerator(new ParameterTypeContext(field.getName(), field.getAnnotatedType(), field.getDeclaringClass().getName()).annotate(field));
    }

    @Override
    @SafeVarargs
    public final <T> Generator<T> oneOf(Class<? extends T> first, Class<? extends T> ... rest) {
        return this.oneOf(this.type(first, new Class[0]), (Generator[])Arrays.stream(rest).map(t -> this.type((Class)t, new Class[0])).toArray(Generator[]::new));
    }

    @Override
    @SafeVarargs
    public final <T> Generator<T> oneOf(Generator<? extends T> first, Generator<? extends T> ... rest) {
        ArrayList<Generator<? extends T>> gens = new ArrayList<Generator<? extends T>>();
        gens.add(first);
        Collections.addAll(gens, rest);
        List<Weighted<Generator<?>>> weightings = gens.stream().map(g -> new Weighted<Generator>((Generator)g, 1)).collect(Collectors.toList());
        return new CompositeGenerator(weightings);
    }

    @Override
    public final <T extends Generator<?>> T make(Class<T> genType, Generator<?> ... components) {
        Generator generator = (Generator)Reflection.instantiate(genType);
        generator.provide(this);
        generator.configure(genType);
        generator.addComponentGenerators(Arrays.asList(components));
        return (T)generator;
    }

    @Override
    public final Generators withRandom(SourceOfRandomness other) {
        return new GeneratorRepository(other, this.generators);
    }

    public Generator<?> produceGenerator(ParameterTypeContext parameter) {
        Generator<?> generator = this.generatorFor(parameter);
        if (!GeneratorRepository.isPrimitiveType(parameter.annotatedType().getType()) && GeneratorRepository.hasNullableAnnotation(parameter.annotatedElement())) {
            generator = new NullableGenerator(generator);
        }
        generator.provide(this);
        generator.configure(parameter.annotatedType());
        if (parameter.topLevel()) {
            generator.configure(parameter.annotatedElement());
        }
        return generator;
    }

    public Generator<?> generatorFor(ParameterTypeContext parameter) {
        if (!parameter.explicitGenerators().isEmpty()) {
            return this.composeWeighted(parameter, parameter.explicitGenerators());
        }
        if (parameter.isArray()) {
            return this.generatorForArrayType(parameter);
        }
        if (parameter.isEnum()) {
            return new EnumGenerator(parameter.getRawClass());
        }
        return this.compose(parameter, this.matchingGenerators(parameter));
    }

    private Generator<?> generatorForArrayType(ParameterTypeContext parameter) {
        ParameterTypeContext component = parameter.arrayComponentContext();
        return new ArrayGenerator(component.getRawClass(), this.generatorFor(component));
    }

    private List<Generator<?>> matchingGenerators(ParameterTypeContext parameter) {
        ArrayList matches = new ArrayList();
        if (!this.hasGeneratorsFor(parameter)) {
            this.maybeAddGeneratorByNamingConvention(parameter, matches);
            this.maybeAddLambdaGenerator(parameter, matches);
        } else {
            this.maybeAddGeneratorsFor(parameter, matches);
        }
        if (matches.isEmpty()) {
            throw new IllegalArgumentException("Cannot find generator for " + parameter.name() + " of type " + parameter.type().getTypeName());
        }
        return matches;
    }

    private void maybeAddGeneratorByNamingConvention(ParameterTypeContext parameter, List<Generator<?>> matches) {
        Class<?> genClass;
        try {
            genClass = Class.forName(parameter.getRawClass().getName() + "Gen");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        if (Generator.class.isAssignableFrom(genClass)) {
            try {
                Generator generator = (Generator)genClass.newInstance();
                if (generator.types().contains(parameter.getRawClass())) {
                    matches.add(generator);
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Cannot instantiate " + genClass.getName() + " using default constructor.");
            }
        }
    }

    private void maybeAddLambdaGenerator(ParameterTypeContext parameter, List<Generator<?>> matches) {
        Method method = Reflection.singleAbstractMethodOf(parameter.getRawClass());
        if (method != null) {
            ParameterTypeContext returnType = new ParameterTypeContext("return value", method.getAnnotatedReturnType(), method.getName()).annotate(method.getAnnotatedReturnType()).allowMixedTypes(true);
            Generator<?> returnTypeGenerator = this.generatorFor(returnType);
            LambdaGenerator lambda = new LambdaGenerator(parameter.getRawClass(), returnTypeGenerator);
            matches.add(lambda);
        }
    }

    private void maybeAddGeneratorsFor(ParameterTypeContext parameter, List<Generator<?>> matches) {
        List<Generator<?>> candidates = this.generatorsFor(parameter);
        List<TypeParameter<?>> typeParameters = parameter.getTypeParameters();
        if (typeParameters.isEmpty()) {
            matches.addAll(candidates);
        } else {
            for (Generator<?> each : candidates) {
                if (!each.canGenerateForParametersOfTypes(typeParameters)) continue;
                matches.add(each);
            }
        }
    }

    private Generator<?> compose(ParameterTypeContext parameter, List<Generator<?>> matches) {
        List<Weighted<Generator<?>>> weightings = matches.stream().map(g -> new Weighted<Generator>((Generator)g, 1)).collect(Collectors.toList());
        return this.composeWeighted(parameter, weightings);
    }

    private Generator<?> composeWeighted(ParameterTypeContext parameter, List<Weighted<Generator<?>>> matches) {
        ArrayList forComponents = new ArrayList();
        for (ParameterTypeContext parameterTypeContext : parameter.typeParameterContexts(this.random)) {
            forComponents.add(this.generatorFor(parameterTypeContext));
        }
        for (Weighted weighted : matches) {
            this.applyComponentGenerators((Generator)weighted.item, forComponents);
        }
        return new CompositeGenerator(matches);
    }

    private void applyComponentGenerators(Generator<?> generator, List<Generator<?>> componentGenerators) {
        if (generator.hasComponents()) {
            if (componentGenerators.isEmpty()) {
                ArrayList substitutes = new ArrayList();
                Generator<?> zilch = this.generatorFor(new ParameterTypeContext("Zilch", null, this.getClass().getName(), GeneratorRepository.token(Zilch.class), Collections.emptyMap()).allowMixedTypes(true));
                for (int i = 0; i < generator.numberOfNeededComponents(); ++i) {
                    substitutes.add(zilch);
                }
                generator.addComponentGenerators(substitutes);
            } else {
                generator.addComponentGenerators(componentGenerators);
            }
        }
    }

    private List<Generator<?>> generatorsFor(ParameterTypeContext parameter) {
        Set<Generator<?>> matches = this.generators.get(parameter.getRawClass());
        if (!parameter.allowMixedTypes()) {
            Generator<?> match = Items.choose(matches, this.random);
            matches = new HashSet();
            matches.add(match);
        }
        ArrayList copies = new ArrayList();
        for (Generator<?> each : matches) {
            copies.add(each.copy());
        }
        return copies;
    }

    private boolean hasGeneratorsFor(ParameterTypeContext parameter) {
        return this.generators.get(parameter.getRawClass()) != null;
    }

    private static org.javaruntype.type.Type<?> token(Type type) {
        return Types.forJavaLangReflectType((Type)type);
    }

    private static boolean isPrimitiveType(Type type) {
        return type instanceof Class && ((Class)type).isPrimitive();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean hasNullableAnnotation(AnnotatedElement annotatedElement) {
        if (annotatedElement == null) return false;
        if (!Arrays.stream(annotatedElement.getAnnotations()).map(Annotation::annotationType).map(Class::getCanonicalName).anyMatch(NULLABLE_ANNOTATIONS::contains)) return false;
        return true;
    }
}

