/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal.sampling;

import com.pholser.junit.quickcheck.conversion.StringConversion;
import com.pholser.junit.quickcheck.generator.Also;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.Only;
import com.pholser.junit.quickcheck.internal.ParameterSampler;
import com.pholser.junit.quickcheck.internal.ParameterTypeContext;
import com.pholser.junit.quickcheck.internal.SeededValue;
import com.pholser.junit.quickcheck.internal.conversion.StringConversions;
import com.pholser.junit.quickcheck.internal.generator.ExhaustiveDomainGenerator;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import com.pholser.junit.quickcheck.internal.generator.GuaranteeValuesGenerator;
import com.pholser.junit.quickcheck.internal.generator.PropertyParameterGenerationContext;
import com.pholser.junit.quickcheck.internal.generator.SamplingDomainGenerator;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TupleParameterSampler
implements ParameterSampler {
    private final int trials;

    public TupleParameterSampler(int trials) {
        this.trials = trials;
    }

    @Override
    public int sizeFactor(ParameterTypeContext p) {
        return this.trials;
    }

    @Override
    public Stream<List<SeededValue>> sample(List<PropertyParameterGenerationContext> parameters) {
        Stream<List> tupleStream = Stream.generate(() -> parameters.stream().map(SeededValue::new).collect(Collectors.toList()));
        return tupleStream.limit(this.trials);
    }

    @Override
    public Generator<?> decideGenerator(GeneratorRepository repository, ParameterTypeContext p) {
        Only only = p.annotatedType().getAnnotation(Only.class);
        if (only != null) {
            StringConversion conversion = StringConversions.decide(p, only);
            Set values = Arrays.stream(only.value()).map(conversion::convert).collect(Collectors.toSet());
            return new SamplingDomainGenerator(values);
        }
        Also also = p.annotatedType().getAnnotation(Also.class);
        if (also != null) {
            StringConversion conversion = StringConversions.decide(p, also);
            Set values = Arrays.stream(also.value()).map(conversion::convert).collect(Collectors.toSet());
            return new GuaranteeValuesGenerator(new ExhaustiveDomainGenerator(values), repository.produceGenerator(p));
        }
        return repository.produceGenerator(p);
    }
}

