/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.time;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.InRange;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class LocalTimeGenerator
extends Generator<LocalTime> {
    private LocalTime min = LocalTime.MIN;
    private LocalTime max = LocalTime.MAX;

    public LocalTimeGenerator() {
        super(LocalTime.class);
    }

    public void configure(InRange range) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(range.format());
        if (!Reflection.defaultValueOf(InRange.class, (String)"min").equals(range.min())) {
            this.min = LocalTime.parse(range.min(), formatter);
        }
        if (!Reflection.defaultValueOf(InRange.class, (String)"max").equals(range.max())) {
            this.max = LocalTime.parse(range.max(), formatter);
        }
        if (this.min.compareTo(this.max) > 0) {
            throw new IllegalArgumentException(String.format("bad range, %s > %s", range.min(), range.max()));
        }
    }

    public LocalTime generate(SourceOfRandomness random, GenerationStatus status) {
        return LocalTime.ofNanoOfDay(random.nextLong(this.min.toNanoOfDay(), this.max.toNanoOfDay()));
    }
}

