/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator.java.util;

import com.pholser.junit.quickcheck.generator.GenerationStatus;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.java.lang.AbstractStringGenerator;
import com.pholser.junit.quickcheck.generator.java.lang.Encoded;
import com.pholser.junit.quickcheck.generator.java.lang.StringGenerator;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class PropertiesGenerator
extends Generator<Properties> {
    private AbstractStringGenerator stringGenerator = new StringGenerator();

    public PropertiesGenerator() {
        super(Properties.class);
    }

    public void configure(Encoded.InCharset charset) {
        Encoded encoded = new Encoded();
        encoded.configure(charset);
        this.stringGenerator = encoded;
    }

    public Properties generate(SourceOfRandomness random, GenerationStatus status) {
        int size = status.size();
        Properties properties = new Properties();
        for (int i = 0; i < size; ++i) {
            properties.setProperty(this.stringGenerator.generate(random, status), this.stringGenerator.generate(random, status));
        }
        return properties;
    }

    public boolean canRegisterAsType(Class<?> type) {
        HashSet<Class> exclusions = new HashSet<Class>(Arrays.asList(Object.class, Hashtable.class, Map.class, Dictionary.class));
        return !exclusions.contains(type);
    }

    public BigDecimal magnitude(Object value) {
        Properties narrowed = (Properties)this.narrow(value);
        if (narrowed.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal keysMagnitude = narrowed.keySet().stream().map(e -> this.stringGenerator.magnitude(e)).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal valuesMagnitude = narrowed.values().stream().map(e -> this.stringGenerator.magnitude(e)).reduce(BigDecimal.ZERO, BigDecimal::add);
        return BigDecimal.valueOf(narrowed.size()).multiply(keysMagnitude).add(valuesMagnitude);
    }
}

