/*
 * Decompiled with CFR 0.152.
 */
package com.planbase.pdf.layoutmanager;

import com.planbase.pdf.layoutmanager.LineStyle;
import com.planbase.pdf.layoutmanager.Utils;
import java.awt.Color;

public class BorderStyle {
    private final LineStyle top;
    private final LineStyle right;
    private final LineStyle bottom;
    private final LineStyle left;
    public static final BorderStyle NO_BORDERS = new BorderStyle(null, null, null, null){

        public String toString() {
            return "BorderStyle.NO_BORDERS";
        }
    };

    private BorderStyle(LineStyle t, LineStyle r, LineStyle b, LineStyle l) {
        this.top = t;
        this.right = r;
        this.bottom = b;
        this.left = l;
    }

    private BorderStyle(Builder b) {
        this.top = b.top;
        this.right = b.right;
        this.bottom = b.bottom;
        this.left = b.left;
    }

    private BorderStyle(Color c, float w) {
        LineStyle style;
        this.top = style = LineStyle.of(c, w);
        this.right = style;
        this.bottom = style;
        this.left = style;
    }

    public static BorderStyle of(Color c, float w) {
        return new BorderStyle(c, w);
    }

    public static BorderStyle of(Color c) {
        return new BorderStyle(c, 1.0f);
    }

    public static Builder builder() {
        return new Builder(null);
    }

    public LineStyle top() {
        return this.top;
    }

    public LineStyle right() {
        return this.right;
    }

    public LineStyle bottom() {
        return this.bottom;
    }

    public LineStyle left() {
        return this.left;
    }

    public BorderStyle top(LineStyle ls) {
        return new Builder(this).top(ls).build();
    }

    public BorderStyle right(LineStyle ls) {
        return new Builder(this).right(ls).build();
    }

    public BorderStyle bottom(LineStyle ls) {
        return new Builder(this).bottom(ls).build();
    }

    public BorderStyle left(LineStyle ls) {
        return new Builder(this).left(ls).build();
    }

    public String toString() {
        StringBuilder sB = new StringBuilder("BorderStyle(");
        if (this.top != null) {
            sB.append("t=").append(this.top);
        }
        if (this.right != null) {
            sB.append("r=").append(this.right);
        }
        if (this.bottom != null) {
            sB.append("b=").append(this.bottom);
        }
        if (this.left != null) {
            sB.append("l=").append(this.left);
        }
        return sB.append(")").toString();
    }

    public static class Builder {
        private LineStyle top;
        private LineStyle right;
        private LineStyle bottom;
        private LineStyle left;

        private Builder(BorderStyle bs) {
            if (bs != null) {
                this.top = bs.top;
                this.right = bs.right;
                this.bottom = bs.bottom;
                this.left = bs.left;
            }
        }

        public Builder top(LineStyle ls) {
            this.top = ls;
            return this;
        }

        public Builder right(LineStyle ls) {
            this.right = ls;
            return this;
        }

        public Builder bottom(LineStyle ls) {
            this.bottom = ls;
            return this;
        }

        public Builder left(LineStyle ls) {
            this.left = ls;
            return this;
        }

        private Builder color(Color c) {
            if (this.top == null) {
                this.top = LineStyle.of(c);
            } else if (!Utils.equals(this.top.color(), c)) {
                this.top = LineStyle.of(c, this.top.width());
            }
            if (this.right == null) {
                this.right = LineStyle.of(c);
            } else if (!Utils.equals(this.right.color(), c)) {
                this.right = LineStyle.of(c, this.right.width());
            }
            if (this.bottom == null) {
                this.bottom = LineStyle.of(c);
            } else if (!Utils.equals(this.bottom.color(), c)) {
                this.bottom = LineStyle.of(c, this.bottom.width());
            }
            if (this.left == null) {
                this.left = LineStyle.of(c);
            } else if (!Utils.equals(this.left.color(), c)) {
                this.left = LineStyle.of(c, this.left.width());
            }
            return this;
        }

        public BorderStyle build() {
            return new BorderStyle(this);
        }
    }
}

