/*
 * Decompiled with CFR 0.152.
 */
package com.planbase.pdf.layoutmanager;

import com.planbase.pdf.layoutmanager.BorderStyle;
import com.planbase.pdf.layoutmanager.CellBuilder;
import com.planbase.pdf.layoutmanager.CellStyle;
import com.planbase.pdf.layoutmanager.LogicalPage;
import com.planbase.pdf.layoutmanager.Padding;
import com.planbase.pdf.layoutmanager.Renderable;
import com.planbase.pdf.layoutmanager.ScaledJpeg;
import com.planbase.pdf.layoutmanager.Text;
import com.planbase.pdf.layoutmanager.TextStyle;
import com.planbase.pdf.layoutmanager.XyDim;
import com.planbase.pdf.layoutmanager.XyOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cell
implements Renderable {
    private final CellStyle cellStyle;
    private final float width;
    private final List<Renderable> rows;
    private final Map<Float, PreCalcRows> preCalcRows = new HashMap<Float, PreCalcRows>(0);

    private Cell(CellStyle cs, float w, List<Renderable> rs) {
        if (w < 0.0f) {
            throw new IllegalArgumentException("A cell cannot have a negative width");
        }
        this.cellStyle = cs;
        this.width = w;
        this.rows = rs;
    }

    public static Cell of(CellStyle cs, float w) {
        return new Cell(cs, w, Collections.<Renderable>emptyList());
    }

    public static Cell of(CellStyle cs, float w, TextStyle ts, String s) {
        ArrayList<Renderable> ls = new ArrayList<Renderable>(1);
        ls.add(Text.of(ts, s));
        return new Cell(cs, w, ls);
    }

    public static Cell of(CellStyle cs, float w, Text t) {
        ArrayList<Renderable> ls = new ArrayList<Renderable>(1);
        ls.add(t);
        return new Cell(cs, w, ls);
    }

    public static Cell of(CellStyle cs, float w, ScaledJpeg j) {
        ArrayList<Renderable> ls = new ArrayList<Renderable>(1);
        ls.add(j);
        return new Cell(cs, w, ls);
    }

    public static Cell of(CellStyle cs, float w, Renderable r) {
        ArrayList<Renderable> ls = new ArrayList<Renderable>(1);
        ls.add(r);
        return new Cell(cs, w, ls);
    }

    public static Cell of(CellStyle cs, float w, List<Renderable> ls) {
        return new Cell(cs, w, ls);
    }

    public static Cell of(CellStyle cs, float w, Cell c) {
        ArrayList<Renderable> ls = new ArrayList<Renderable>(1);
        ls.add(c);
        return new Cell(cs, w, ls);
    }

    public CellStyle cellStyle() {
        return this.cellStyle;
    }

    public float width() {
        return this.width;
    }

    private void calcDimensionsForReal(float maxWidth) {
        PreCalcRows pcrs = new PreCalcRows();
        XyDim blockDim = XyDim.ZERO;
        Padding padding = this.cellStyle.padding();
        float innerWidth = maxWidth;
        if (padding != null) {
            innerWidth -= padding.left() + padding.right();
        }
        for (Renderable row : this.rows) {
            XyDim rowDim = row == null ? XyDim.ZERO : row.calcDimensions(innerWidth);
            blockDim = XyDim.of(Math.max(blockDim.x(), rowDim.x()), blockDim.y() + rowDim.y());
            pcrs.rows.add(PreCalcRow.of(row, rowDim));
        }
        pcrs.blockDim = blockDim;
        this.preCalcRows.put(Float.valueOf(maxWidth), pcrs);
    }

    private PreCalcRows ensurePreCalcRows(float maxWidth) {
        PreCalcRows pcr = this.preCalcRows.get(Float.valueOf(maxWidth));
        if (pcr == null) {
            this.calcDimensionsForReal(maxWidth);
            pcr = this.preCalcRows.get(Float.valueOf(maxWidth));
        }
        return pcr;
    }

    @Override
    public XyDim calcDimensions(float maxWidth) {
        XyDim blockDim = this.ensurePreCalcRows((float)maxWidth).blockDim;
        XyDim ret = this.cellStyle.padding() == null ? blockDim : this.cellStyle.padding().addTo(blockDim);
        return ret;
    }

    @Override
    public XyOffset render(LogicalPage lp, XyOffset outerTopLeft, XyDim outerDimensions, boolean allPages) {
        XyDim innerDimensions;
        XyOffset innerTopLeft;
        float maxWidth = outerDimensions.x();
        PreCalcRows pcrs = this.ensurePreCalcRows(maxWidth);
        Padding padding = this.cellStyle.padding();
        if (this.cellStyle.bgColor() != null) {
            lp.putRect(outerTopLeft, outerDimensions, this.cellStyle.bgColor());
        }
        if (padding == null) {
            innerTopLeft = outerTopLeft;
            innerDimensions = outerDimensions;
        } else {
            innerTopLeft = padding.applyTopLeft(outerTopLeft);
            innerDimensions = padding.subtractFrom(outerDimensions);
        }
        XyDim wrappedBlockDim = pcrs.blockDim;
        Padding alignPad = this.cellStyle.align().calcPadding(innerDimensions, wrappedBlockDim);
        if (alignPad != null) {
            innerTopLeft = XyOffset.of(innerTopLeft.x() + alignPad.left(), innerTopLeft.y() - alignPad.top());
        }
        XyOffset outerLowerRight = innerTopLeft;
        for (int i = 0; i < this.rows.size(); ++i) {
            Renderable row = this.rows.get(i);
            if (row == null) continue;
            PreCalcRow pcr = pcrs.rows.get(i);
            float rowXOffset = this.cellStyle.align().leftOffset(wrappedBlockDim.x(), pcr.blockDim.x());
            outerLowerRight = row.render(lp, innerTopLeft.x(innerTopLeft.x() + rowXOffset), pcr.blockDim, allPages);
            innerTopLeft = outerLowerRight.x(innerTopLeft.x());
        }
        BorderStyle border = this.cellStyle.borderStyle();
        if (border != null) {
            float origX = outerTopLeft.x();
            float origY = outerTopLeft.y();
            float rightX = outerTopLeft.x() + outerDimensions.x();
            float bottomY = outerTopLeft.y() - outerDimensions.y();
            if (border.top() != null) {
                lp.putLine(origX, origY, rightX, origY, border.top());
            }
            if (border.right() != null) {
                lp.putLine(rightX, origY, rightX, bottomY, border.right());
            }
            if (border.bottom() != null) {
                lp.putLine(origX, bottomY, rightX, bottomY, border.bottom());
            }
            if (border.left() != null) {
                lp.putLine(origX, origY, origX, bottomY, border.left());
            }
        }
        return outerLowerRight;
    }

    public static Builder builder(CellStyle cellStyle, float width) {
        return new Builder(cellStyle, width);
    }

    public String toString() {
        StringBuilder sB = new StringBuilder("Cell(").append(this.cellStyle).append(" width=").append(this.width).append(" rows=[");
        for (int i = 0; i < this.rows.size() && i < 3; ++i) {
            if (i > 0) {
                sB.append(" ");
            }
            sB.append(this.rows.get(i));
        }
        return sB.append("])").toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements CellBuilder {
        private final float width;
        private CellStyle cellStyle;
        private final List<Renderable> rows = new ArrayList<Renderable>();
        private TextStyle textStyle;

        private Builder(CellStyle cs, float w) {
            this.width = w;
            this.cellStyle = cs;
        }

        @Override
        public Builder cellStyle(CellStyle cs) {
            this.cellStyle = cs;
            return this;
        }

        @Override
        public Builder align(CellStyle.Align align) {
            this.cellStyle = this.cellStyle.align(align);
            return this;
        }

        @Override
        public Builder textStyle(TextStyle x) {
            this.textStyle = x;
            return this;
        }

        @Override
        public Builder add(Renderable ... rs) {
            Collections.addAll(this.rows, rs);
            return this;
        }

        @Override
        public Builder add(List<Renderable> js) {
            if (js != null) {
                this.rows.addAll(js);
            }
            return this;
        }

        @Override
        public Builder add(TextStyle ts, List<String> ls) {
            if (ls != null) {
                for (String s : ls) {
                    this.rows.add(Text.of(ts, s));
                }
            }
            return this;
        }

        @Override
        public Builder add(String ... ss) {
            if (this.textStyle == null) {
                throw new IllegalStateException("Must set a default text style before adding raw strings");
            }
            for (String s : ss) {
                this.rows.add(Text.of(this.textStyle, s));
            }
            return this;
        }

        public Cell build() {
            return new Cell(this.cellStyle, this.width, this.rows);
        }

        public String toString() {
            StringBuilder sB = new StringBuilder("Cell.Builder(").append(this.cellStyle).append(" width=").append(this.width).append(" rows=[");
            for (int i = 0; i < this.rows.size() && i < 3; ++i) {
                if (i > 0) {
                    sB.append(" ");
                }
                sB.append(this.rows.get(i));
            }
            return sB.append("])").toString();
        }
    }

    private static class PreCalcRows {
        List<PreCalcRow> rows = new ArrayList<PreCalcRow>(1);
        XyDim blockDim;

        private PreCalcRows() {
        }
    }

    private static class PreCalcRow {
        Renderable row;
        XyDim blockDim;

        private PreCalcRow() {
        }

        public static PreCalcRow of(Renderable r, XyDim d) {
            PreCalcRow pcr = new PreCalcRow();
            pcr.row = r;
            pcr.blockDim = d;
            return pcr;
        }
    }
}

