/*
 * Decompiled with CFR 0.152.
 */
package com.planbase.pdf.layoutmanager;

import com.planbase.pdf.layoutmanager.BorderStyle;
import com.planbase.pdf.layoutmanager.Padding;
import com.planbase.pdf.layoutmanager.Utils;
import com.planbase.pdf.layoutmanager.XyDim;
import java.awt.Color;

public class CellStyle {
    public static final Align DEFAULT_ALIGN = Align.TOP_LEFT;
    public static final CellStyle DEFAULT = new CellStyle(DEFAULT_ALIGN, null, null, null);
    private final Align align;
    private final Padding padding;
    private final Color bgColor;
    private final BorderStyle borderStyle;

    private CellStyle(Align a, Padding p, Color bg, BorderStyle b) {
        this.align = a;
        this.padding = p;
        this.bgColor = bg;
        this.borderStyle = b;
    }

    public static CellStyle of(Align a, Padding p, Color bg, BorderStyle b) {
        return CellStyle.builder().align(a).padding(p).bgColor(bg).borderStyle(b).build();
    }

    public Align align() {
        return this.align;
    }

    public Padding padding() {
        return this.padding;
    }

    public Color bgColor() {
        return this.bgColor;
    }

    public BorderStyle borderStyle() {
        return this.borderStyle;
    }

    public CellStyle align(Align a) {
        return new Builder(this).align(a).build();
    }

    public CellStyle padding(Padding p) {
        return new Builder(this).padding(p).build();
    }

    public CellStyle bgColor(Color c) {
        return new Builder(this).bgColor(c).build();
    }

    public CellStyle borderStyle(BorderStyle bs) {
        return new Builder(this).borderStyle(bs).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sB = new StringBuilder("CellStyle(").append((Object)this.align);
        if (this.padding != null) {
            sB.append(" ").append(this.padding);
        }
        if (this.bgColor != null) {
            sB.append(" ").append(Utils.toString(this.bgColor));
        }
        if (this.borderStyle != null) {
            sB.append(" ").append(this.borderStyle);
        }
        return sB.append(")").toString();
    }

    public static class Builder {
        private Align align;
        private Padding padding;
        private Color bgColor;
        private BorderStyle borderStyle;

        private Builder() {
        }

        private Builder(CellStyle cs) {
            this.align = cs.align;
            this.padding = cs.padding;
            this.bgColor = cs.bgColor;
            this.borderStyle = cs.borderStyle;
        }

        public CellStyle build() {
            if (this.align == null) {
                this.align = DEFAULT_ALIGN;
            }
            if (this.padding == null) {
                this.padding = Padding.DEFAULT_TEXT_PADDING;
            }
            if (!(this.align != DEFAULT_ALIGN || this.padding != Padding.DEFAULT_TEXT_PADDING || this.bgColor != null && !this.bgColor.equals(Color.WHITE) || this.borderStyle != null && this.borderStyle != BorderStyle.NO_BORDERS)) {
                return DEFAULT;
            }
            return new CellStyle(this.align, this.padding, this.bgColor, this.borderStyle);
        }

        public Builder align(Align a) {
            this.align = a;
            return this;
        }

        public Builder padding(Padding p) {
            this.padding = p;
            return this;
        }

        public Builder bgColor(Color c) {
            this.bgColor = c;
            return this;
        }

        public Builder borderStyle(BorderStyle bs) {
            this.borderStyle = bs;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Align {
        TOP_LEFT{

            public Padding calcPadding(XyDim outer, XyDim inner) {
                if (outer.lte(inner)) {
                    return null;
                }
                return Padding.of(0.0f, outer.x() - inner.x(), outer.y() - inner.y(), 0.0f);
            }

            public float leftOffset(float outerWidth, float innerWidth) {
                return 0.0f;
            }
        }
        ,
        TOP_CENTER{

            public Padding calcPadding(XyDim outer, XyDim inner) {
                if (outer.lte(inner)) {
                    return null;
                }
                float dx = (outer.x() - inner.x()) / 2.0f;
                return Padding.of(0.0f, dx, outer.y() - inner.y(), dx);
            }

            public float leftOffset(float outerWidth, float innerWidth) {
                return innerWidth >= outerWidth ? 0.0f : (outerWidth - innerWidth) / 2.0f;
            }
        }
        ,
        TOP_RIGHT{

            public Padding calcPadding(XyDim outer, XyDim inner) {
                if (outer.lte(inner)) {
                    return null;
                }
                return Padding.of(0.0f, 0.0f, outer.y() - inner.y(), outer.x() - inner.x());
            }

            public float leftOffset(float outerWidth, float innerWidth) {
                return innerWidth >= outerWidth ? 0.0f : outerWidth - innerWidth;
            }
        }
        ,
        MIDDLE_LEFT{

            public Padding calcPadding(XyDim outer, XyDim inner) {
                if (outer.lte(inner)) {
                    return null;
                }
                float dy = (outer.y() - inner.y()) / 2.0f;
                return Padding.of(dy, outer.x() - inner.x(), dy, 0.0f);
            }

            public float leftOffset(float outerWidth, float innerWidth) {
                return 0.0f;
            }
        }
        ,
        MIDDLE_CENTER{

            public Padding calcPadding(XyDim outer, XyDim inner) {
                if (outer.lte(inner)) {
                    return null;
                }
                float dx = (outer.x() - inner.x()) / 2.0f;
                float dy = (outer.y() - inner.y()) / 2.0f;
                return Padding.of(dy, dx, dy, dx);
            }

            public float leftOffset(float outerWidth, float innerWidth) {
                return innerWidth >= outerWidth ? 0.0f : (outerWidth - innerWidth) / 2.0f;
            }
        }
        ,
        MIDDLE_RIGHT{

            public Padding calcPadding(XyDim outer, XyDim inner) {
                if (outer.lte(inner)) {
                    return null;
                }
                float dy = (outer.y() - inner.y()) / 2.0f;
                return Padding.of(dy, 0.0f, dy, outer.x() - inner.x());
            }

            public float leftOffset(float outerWidth, float innerWidth) {
                return innerWidth >= outerWidth ? 0.0f : outerWidth - innerWidth;
            }
        }
        ,
        BOTTOM_LEFT{

            public Padding calcPadding(XyDim outer, XyDim inner) {
                if (outer.lte(inner)) {
                    return null;
                }
                return Padding.of(outer.y() - inner.y(), outer.x() - inner.x(), 0.0f, 0.0f);
            }

            public float leftOffset(float outerWidth, float innerWidth) {
                return 0.0f;
            }
        }
        ,
        BOTTOM_CENTER{

            public Padding calcPadding(XyDim outer, XyDim inner) {
                if (outer.lte(inner)) {
                    return null;
                }
                float dx = (outer.x() - inner.x()) / 2.0f;
                return Padding.of(outer.y() - inner.y(), dx, 0.0f, dx);
            }

            public float leftOffset(float outerWidth, float innerWidth) {
                return innerWidth >= outerWidth ? 0.0f : (outerWidth - innerWidth) / 2.0f;
            }
        }
        ,
        BOTTOM_RIGHT{

            public Padding calcPadding(XyDim outer, XyDim inner) {
                if (outer.lte(inner)) {
                    return null;
                }
                return Padding.of(outer.y() - inner.y(), 0.0f, 0.0f, outer.x() - inner.x());
            }

            public float leftOffset(float outerWidth, float innerWidth) {
                return innerWidth >= outerWidth ? 0.0f : outerWidth - innerWidth;
            }
        };


        public abstract Padding calcPadding(XyDim var1, XyDim var2);

        public abstract float leftOffset(float var1, float var2);
    }
}

