/*
 * Decompiled with CFR 0.152.
 */
package com.planbase.pdf.layoutmanager;

import com.planbase.pdf.layoutmanager.Utils;
import java.awt.Color;

public class LineStyle {
    public static final float DEFAULT_WIDTH = 1.0f;
    private final Color color;
    private final float width;

    private LineStyle(Color c, float w) {
        if (c == null) {
            throw new IllegalArgumentException("Line Style must have a color.");
        }
        if (w <= 0.0f) {
            throw new IllegalArgumentException("Line Style must have a positive width.");
        }
        this.color = c;
        this.width = w;
    }

    public static LineStyle of(Color c, float w) {
        return new LineStyle(c, w);
    }

    public static LineStyle of(Color c) {
        return new LineStyle(c, 1.0f);
    }

    public Color color() {
        return this.color;
    }

    public float width() {
        return this.width;
    }

    public int hashCode() {
        int code = (int)this.width * 100;
        return code |= this.color.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof LineStyle) || this.hashCode() != other.hashCode()) {
            return false;
        }
        LineStyle that = (LineStyle)other;
        return this.width == that.width && this.color().equals(that.color());
    }

    public String toString() {
        return "LineStyle(" + Utils.toString(this.color) + " w=" + this.width + ")";
    }
}

