/*
 * Decompiled with CFR 0.152.
 */
package com.planbase.pdf.layoutmanager;

import com.planbase.pdf.layoutmanager.Cell;
import com.planbase.pdf.layoutmanager.LineStyle;
import com.planbase.pdf.layoutmanager.PdfItem;
import com.planbase.pdf.layoutmanager.PdfLayoutMgr;
import com.planbase.pdf.layoutmanager.ScaledJpeg;
import com.planbase.pdf.layoutmanager.ScaledPng;
import com.planbase.pdf.layoutmanager.TableBuilder;
import com.planbase.pdf.layoutmanager.TextStyle;
import com.planbase.pdf.layoutmanager.XyDim;
import com.planbase.pdf.layoutmanager.XyOffset;
import java.awt.Color;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;

public class LogicalPage {
    private final PdfLayoutMgr mgr;
    private final boolean portrait;
    private Set<PdfItem> borderItems = new TreeSet<PdfItem>();
    private int borderOrd = 0;
    boolean valid = true;

    public float yPageTop() {
        return 755.0f;
    }

    public float yPageBottom() {
        return this.portrait ? 0.0f : 230.0f;
    }

    public float printAreaHeight() {
        return this.yPageTop() - this.yPageBottom();
    }

    public float pageWidth() {
        return this.portrait ? PDPage.PAGE_SIZE_LETTER.getWidth() : PDPage.PAGE_SIZE_LETTER.getHeight();
    }

    private LogicalPage(PdfLayoutMgr m, boolean p) {
        this.mgr = m;
        this.portrait = p;
    }

    public static LogicalPage of(PdfLayoutMgr m) {
        return new LogicalPage(m, false);
    }

    public static LogicalPage of(PdfLayoutMgr m, Orientation orientation) {
        return new LogicalPage(m, orientation == Orientation.PORTRAIT);
    }

    public Orientation orientation() {
        return this.portrait ? Orientation.PORTRAIT : Orientation.LANDSCAPE;
    }

    public TableBuilder tableBuilder(XyOffset tl) {
        if (!this.valid) {
            throw new IllegalStateException("Logical page accessed after commit");
        }
        return TableBuilder.of(this, tl);
    }

    public PdfLayoutMgr commit() throws IOException {
        this.mgr.logicalPageEnd(this);
        this.valid = false;
        return this.mgr;
    }

    LogicalPage drawStyledText(float x, float y, String s, TextStyle textStyle) {
        if (!this.valid) {
            throw new IllegalStateException("Logical page accessed after commit");
        }
        PageBufferAndY pby = this.mgr.appropriatePage(this, y);
        pby.pb.drawStyledText(x, pby.y, s, textStyle);
        return this;
    }

    LogicalPage drawJpeg(float xVal, float yVal, ScaledJpeg sj) {
        if (!this.valid) {
            throw new IllegalStateException("Logical page accessed after commit");
        }
        PageBufferAndY pby = this.mgr.appropriatePage(this, yVal);
        pby.pb.drawJpeg(xVal, pby.y, sj, this.mgr);
        return this;
    }

    LogicalPage drawPng(float xVal, float yVal, ScaledPng sj) {
        if (!this.valid) {
            throw new IllegalStateException("Logical page accessed after commit");
        }
        PageBufferAndY pby = this.mgr.appropriatePage(this, yVal);
        pby.pb.drawPng(xVal, pby.y, sj, this.mgr);
        return this;
    }

    public LogicalPage putRect(XyOffset outerTopLeft, XyDim outerDimensions, Color c) {
        PageBufferAndY pby2;
        if (!this.valid) {
            throw new IllegalStateException("Logical page accessed after commit");
        }
        float left = outerTopLeft.x();
        float topY = outerTopLeft.y();
        float width = outerDimensions.x();
        float maxHeight = outerDimensions.y();
        float bottomY = topY - maxHeight;
        if (topY < bottomY) {
            throw new IllegalStateException("height must be positive");
        }
        PageBufferAndY pby1 = this.mgr.appropriatePage(this, topY);
        if (pby1.equals(pby2 = this.mgr.appropriatePage(this, bottomY))) {
            pby1.pb.fillRect(left, pby1.y, width, maxHeight, c, -1.0f);
        } else {
            int totalPages = pby2.pb.pageNum - pby1.pb.pageNum + 1;
            PdfLayoutMgr.PageBuffer currPage = pby1.pb;
            float ya = topY;
            float yb = 0.0f;
            for (int pageNum = 1; pageNum <= totalPages; ++pageNum) {
                ya = pby1.pb.pageNum < currPage.pageNum ? this.yPageTop() : pby1.y;
                yb = pageNum == totalPages ? pby2.y : this.yPageBottom();
                currPage.fillRect(left, yb, width, ya - yb, c, -1.0f);
                if (pageNum >= totalPages) continue;
                currPage = this.mgr.pages().get(currPage.pageNum);
            }
        }
        return this;
    }

    public LogicalPage putLine(float x1, float y1, float x2, float y2, LineStyle ls) {
        PageBufferAndY pby2;
        if (!this.valid) {
            throw new IllegalStateException("Logical page accessed after commit");
        }
        if (y1 < y2) {
            throw new IllegalStateException("y1 param must be >= y2 param");
        }
        PageBufferAndY pby1 = this.mgr.appropriatePage(this, y1);
        if (pby1.equals(pby2 = this.mgr.appropriatePage(this, y2))) {
            pby1.pb.drawLine(x1, pby1.y, x2, pby2.y, ls);
        } else {
            int totalPages = pby2.pb.pageNum - pby1.pb.pageNum + 1;
            float xDiff = x2 - x1;
            float yDiff = y1 - y2;
            PdfLayoutMgr.PageBuffer currPage = pby1.pb;
            float xa = x1;
            float ya = y1;
            float xb = 0.0f;
            float yb = 0.0f;
            for (int pageNum = 1; pageNum <= totalPages; ++pageNum) {
                if (pageNum > 1) {
                    xa = xb;
                }
                ya = pby1.pb.pageNum < currPage.pageNum ? this.yPageTop() : pby1.y;
                if (pageNum == totalPages) {
                    xb = x2;
                    yb = pby2.y;
                } else {
                    yb = this.yPageBottom();
                    xb = xa + xDiff * ((ya - yb) / yDiff);
                }
                currPage.drawLine(xa, ya, xb, yb, ls);
                if (pageNum >= totalPages) continue;
                currPage = this.mgr.pages().get(currPage.pageNum);
            }
        }
        return this;
    }

    public XyOffset putCell(float topLeftX, float topLeftY, Cell cell) {
        if (!this.valid) {
            throw new IllegalStateException("Logical page accessed after commit");
        }
        XyDim maxDim = XyDim.ZERO;
        XyDim wh = cell.calcDimensions(cell.width());
        maxDim = XyDim.of(wh.x() + maxDim.x(), Math.max(maxDim.y(), wh.y()));
        float maxHeight = maxDim.y();
        cell.render(this, XyOffset.of(topLeftX, topLeftY), XyDim.of(cell.width(), maxHeight), false);
        return XyOffset.of(topLeftX + wh.x(), topLeftY - wh.y());
    }

    public XyOffset addTable(TableBuilder tb) {
        if (!this.valid) {
            throw new IllegalStateException("Logical page accessed after commit");
        }
        return tb.render(this, tb.topLeft(), null, false);
    }

    public float putRow(float initialX, float origY, Cell ... cells) throws IOException {
        if (!this.valid) {
            throw new IllegalStateException("Logical page accessed after commit");
        }
        XyDim maxDim = XyDim.ZERO;
        for (Cell cell : cells) {
            XyDim wh = cell.calcDimensions(cell.width());
            maxDim = XyDim.of(wh.x() + maxDim.x(), Math.max(maxDim.y(), wh.y()));
        }
        float maxHeight = maxDim.y();
        float x = initialX;
        for (Cell cell : cells) {
            cell.render(this, XyOffset.of(x, origY), XyDim.of(cell.width(), maxHeight), false);
            x += cell.width();
        }
        return origY - maxHeight;
    }

    public float putCellAsHeaderFooter(float x, float origY, Cell cell) {
        if (!this.valid) {
            throw new IllegalStateException("Logical page accessed after commit");
        }
        float outerWidth = cell.width();
        XyDim innerDim = cell.calcDimensions(outerWidth);
        return cell.render(this, XyOffset.of(x, origY), innerDim.x(outerWidth), true).y();
    }

    void commitBorderItems(PDPageContentStream stream) throws IOException {
        if (!this.valid) {
            throw new IllegalStateException("Logical page accessed after commit");
        }
        for (PdfItem item : this.borderItems) {
            item.commit(stream);
        }
    }

    private void borderStyledText(float xCoord, float yCoord, String text, TextStyle s, float z) {
        if (!this.valid) {
            throw new IllegalStateException("Logical page accessed after commit");
        }
        this.borderItems.add(PdfLayoutMgr.PageBuffer.Text.of(xCoord, yCoord, text, s, this.borderOrd++, z));
    }

    void borderStyledText(float xCoord, float yCoord, String text, TextStyle s) {
        if (!this.valid) {
            throw new IllegalStateException("Logical page accessed after commit");
        }
        this.borderStyledText(xCoord, yCoord, text, s, 0.0f);
    }

    static class PageBufferAndY {
        public final PdfLayoutMgr.PageBuffer pb;
        public final float y;

        public PageBufferAndY(PdfLayoutMgr.PageBuffer p, float theY) {
            this.pb = p;
            this.y = theY;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        PORTRAIT,
        LANDSCAPE;

    }
}

