/*
 * Decompiled with CFR 0.152.
 */
package com.planbase.pdf.layoutmanager;

import com.planbase.pdf.layoutmanager.XyDim;
import com.planbase.pdf.layoutmanager.XyOffset;

public class Padding {
    public static final Padding DEFAULT_TEXT_PADDING = new Padding(1.5f, 1.5f, 2.0f, 1.5f);
    public static final Padding NO_PADDING = new Padding(0.0f, 0.0f, 0.0f, 0.0f);
    private final float top;
    private final float right;
    private final float bottom;
    private final float left;

    private Padding(float t, float r, float b, float l) {
        this.top = t;
        this.right = r;
        this.bottom = b;
        this.left = l;
    }

    public static Padding of(float t, float r, float b, float l) {
        if (t == 0.0f && r == 0.0f && b == 0.0f && l == 0.0f) {
            return NO_PADDING;
        }
        if (t == 1.5f && r == 1.5f && b == 2.0f && l == 1.5f) {
            return DEFAULT_TEXT_PADDING;
        }
        return new Padding(t, r, b, l);
    }

    public static Padding of(float a) {
        if (a == 0.0f) {
            return NO_PADDING;
        }
        return new Padding(a, a, a, a);
    }

    public XyDim topLeftPadDim() {
        return XyDim.of(this.left, this.top);
    }

    public XyDim botRightPadDim() {
        return XyDim.of(this.right, this.bottom);
    }

    public XyDim subtractFrom(XyDim outer) {
        return XyDim.of(outer.x() - (this.left + this.right), outer.y() - (this.top + this.bottom));
    }

    public XyDim addTo(XyDim outer) {
        return XyDim.of(outer.x() + (this.left + this.right), outer.y() + (this.top + this.bottom));
    }

    public XyOffset applyTopLeft(XyOffset orig) {
        return XyOffset.of(orig.x() + this.left, orig.y() - this.top);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Padding)) {
            return false;
        }
        Padding that = (Padding)other;
        return this.top == that.top && this.right == that.right && this.bottom == that.bottom && this.left == that.left;
    }

    public int hashCode() {
        return (int)((this.top + this.right + this.bottom + this.left) * 40.0f);
    }

    public String toString() {
        if (this.top == this.right && this.top == this.bottom && this.top == this.left) {
            return "Padding(" + this.top + ")";
        }
        return "Padding(t=" + this.top + ", r=" + this.right + ", b=" + this.bottom + ", l=" + this.left + ")";
    }

    public float top() {
        return this.top;
    }

    public float right() {
        return this.right;
    }

    public float bottom() {
        return this.bottom;
    }

    public float left() {
        return this.left;
    }
}

