/*
 * Decompiled with CFR 0.152.
 */
package com.planbase.pdf.layoutmanager;

import java.io.IOException;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PdfItem
implements Comparable<PdfItem> {
    public static final float DEFAULT_Z_INDEX = 0.0f;
    private final long serialNumber;
    private final float z;

    PdfItem(long ord, float zIndex) {
        this.z = zIndex;
        this.serialNumber = ord;
    }

    public abstract void commit(PDPageContentStream var1) throws IOException;

    @Override
    public int compareTo(PdfItem that) {
        float zDiff = this.z - that.z;
        if (zDiff > 0.0f) {
            return 1;
        }
        if (zDiff < 0.0f) {
            return -1;
        }
        long oDiff = this.serialNumber - that.serialNumber;
        if (oDiff > 0L) {
            return 1;
        }
        if (oDiff < 0L) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof PdfItem) || this.hashCode() != other.hashCode()) {
            return false;
        }
        PdfItem that = (PdfItem)other;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return (int)(this.z * 1000.0f) + (int)this.serialNumber;
    }
}

