/*
 * Decompiled with CFR 0.152.
 */
package com.planbase.pdf.layoutmanager;

import com.planbase.pdf.layoutmanager.LineStyle;
import com.planbase.pdf.layoutmanager.LogicalPage;
import com.planbase.pdf.layoutmanager.PdfItem;
import com.planbase.pdf.layoutmanager.ScaledJpeg;
import com.planbase.pdf.layoutmanager.ScaledPng;
import com.planbase.pdf.layoutmanager.TextStyle;
import com.planbase.pdf.layoutmanager.XyDim;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDJpeg;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDPixelMap;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfLayoutMgr {
    public static final float DOC_UNITS_PER_INCH = 72.0f;
    private final Map<BufferedImage, PDJpeg> jpegMap = new HashMap<BufferedImage, PDJpeg>();
    private final Map<BufferedImage, PDPixelMap> pngMap = new HashMap<BufferedImage, PDPixelMap>();
    private final List<PageBuffer> pages = new ArrayList<PageBuffer>();
    private final PDDocument doc = new PDDocument();
    private int unCommittedPageIdx = 0;
    private final PDColorSpace colorSpace;
    private static final String ISO_8859_1 = "ISO_8859_1";
    private static final String UNICODE_BULLET = "\u2022";
    private static final Map<String, String> utf16ToWinAnsi;
    private static final Pattern nonAsciiPattern;

    private PDJpeg ensureCached(ScaledJpeg sj) {
        BufferedImage bufferedImage = sj.bufferedImage();
        PDJpeg temp = this.jpegMap.get(bufferedImage);
        if (temp == null) {
            try {
                temp = new PDJpeg(this.doc, bufferedImage);
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Caught exception creating a PDJpeg from a bufferedImage", ioe);
            }
            this.jpegMap.put(bufferedImage, temp);
        }
        return temp;
    }

    private PDPixelMap ensureCached(ScaledPng sj) {
        BufferedImage bufferedImage = sj.bufferedImage();
        PDPixelMap temp = this.pngMap.get(bufferedImage);
        if (temp == null) {
            try {
                temp = new PDPixelMap(this.doc, bufferedImage);
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Caught exception creating a PDPixelMap from a bufferedImage", ioe);
            }
            this.pngMap.put(bufferedImage, temp);
        }
        return temp;
    }

    List<PageBuffer> pages() {
        return Collections.unmodifiableList(this.pages);
    }

    private PdfLayoutMgr(PDColorSpace cs) throws IOException {
        this.colorSpace = cs;
    }

    public static PdfLayoutMgr of(PDColorSpace cs) throws IOException {
        return new PdfLayoutMgr(cs);
    }

    public static PdfLayoutMgr newRgbPageMgr() throws IOException {
        return new PdfLayoutMgr((PDColorSpace)PDDeviceRGB.INSTANCE);
    }

    LogicalPage.PageBufferAndY appropriatePage(LogicalPage lp, float y) {
        if (this.pages.size() < 1) {
            throw new IllegalStateException("Cannot work with the any pages until one has been created by calling newPage().");
        }
        int idx = this.unCommittedPageIdx;
        while (y < lp.yPageBottom()) {
            y += lp.printAreaHeight();
            if (this.pages.size() > ++idx) continue;
            this.pages.add(new PageBuffer(this.pages.size() + 1));
        }
        PageBuffer ps = this.pages.get(idx);
        return new LogicalPage.PageBufferAndY(ps, y);
    }

    public void save(OutputStream os) throws IOException, COSVisitorException {
        this.doc.save(os);
        this.doc.close();
    }

    public LogicalPage logicalPageStart(LogicalPage.Orientation o) {
        PageBuffer pb = new PageBuffer(this.pages.size() + 1);
        this.pages.add(pb);
        return LogicalPage.of(this, o);
    }

    public LogicalPage logicalPageStart() {
        return this.logicalPageStart(LogicalPage.Orientation.LANDSCAPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logicalPageEnd(LogicalPage lp) throws IOException {
        while (this.unCommittedPageIdx < this.pages.size()) {
            PDPage pdPage = new PDPage();
            pdPage.setMediaBox(PDPage.PAGE_SIZE_LETTER);
            if (lp.orientation() == LogicalPage.Orientation.LANDSCAPE) {
                pdPage.setRotation(90);
            }
            PDPageContentStream stream = null;
            try {
                stream = new PDPageContentStream(this.doc, pdPage);
                this.doc.addPage(pdPage);
                if (lp.orientation() == LogicalPage.Orientation.LANDSCAPE) {
                    stream.concatenate2CTM(0.0, 1.0, -1.0, 0.0, (double)lp.pageWidth(), 0.0);
                }
                stream.setStrokingColorSpace(this.colorSpace);
                stream.setNonStrokingColorSpace(this.colorSpace);
                PageBuffer pb = this.pages.get(this.unCommittedPageIdx);
                pb.commit(stream);
                lp.commitBorderItems(stream);
                stream.close();
                stream = null;
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            ++this.unCommittedPageIdx;
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof PdfLayoutMgr)) {
            return false;
        }
        PdfLayoutMgr that = (PdfLayoutMgr)other;
        return this.doc.equals(that.doc) && this.pages.equals(that.pages);
    }

    public int hashCode() {
        return this.doc.hashCode() + this.pages.hashCode();
    }

    public static String convertJavaStringToWinAnsi(String in) {
        Matcher m = nonAsciiPattern.matcher(in);
        StringBuilder sB = new StringBuilder();
        int idx = 0;
        while (m.find()) {
            String s;
            int start = m.start();
            if (idx < start) {
                sB.append(in.subSequence(idx, start));
            }
            if ((s = utf16ToWinAnsi.get(m.group())) == null) {
                s = utf16ToWinAnsi.get(UNICODE_BULLET);
            }
            sB.append(s);
            idx = m.end();
        }
        if (idx < in.length()) {
            sB.append(in.subSequence(idx, in.length()));
        }
        return sB.toString();
    }

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        try {
            tempMap.put("\u0152", new String(new byte[]{0, -116}, ISO_8859_1));
            tempMap.put("\u0153", new String(new byte[]{0, -100}, ISO_8859_1));
            tempMap.put("\u0160", new String(new byte[]{0, -118}, ISO_8859_1));
            tempMap.put("\u0161", new String(new byte[]{0, -102}, ISO_8859_1));
            tempMap.put("\u0178", new String(new byte[]{0, -97}, ISO_8859_1));
            tempMap.put("\u017d", new String(new byte[]{0, -114}, ISO_8859_1));
            tempMap.put("\u017e", new String(new byte[]{0, -98}, ISO_8859_1));
            tempMap.put("\u0192", new String(new byte[]{0, -125}, ISO_8859_1));
            tempMap.put("\u02c6", new String(new byte[]{0, -120}, ISO_8859_1));
            tempMap.put("\u02dc", new String(new byte[]{0, -104}, ISO_8859_1));
            tempMap.put("\u0400", new String(new byte[]{0, -56}, ISO_8859_1));
            tempMap.put("\u0401", new String(new byte[]{0, -53}, ISO_8859_1));
            tempMap.put("\u0402", new String(new byte[]{0, -48}, ISO_8859_1));
            tempMap.put("\u0404", new String(new byte[]{0, -54}, ISO_8859_1));
            tempMap.put("\u0405", "S");
            tempMap.put("\u0406", new String(new byte[]{0, -52}, ISO_8859_1));
            tempMap.put("\u0407", new String(new byte[]{0, -49}, ISO_8859_1));
            tempMap.put("\u0410", "A");
            tempMap.put("\u0411", "B");
            tempMap.put("\u0412", "V");
            tempMap.put("\u0413", "G");
            tempMap.put("\u0414", "D");
            tempMap.put("\u0415", "E");
            tempMap.put("\u0416", new String(new byte[]{0, -114}, ISO_8859_1));
            tempMap.put("\u0417", "Z");
            tempMap.put("\u0418", "I");
            tempMap.put("\u0419", "J");
            tempMap.put("\u041a", "K");
            tempMap.put("\u041b", "L");
            tempMap.put("\u041c", "M");
            tempMap.put("\u041d", "N");
            tempMap.put("\u041e", "O");
            tempMap.put("\u041f", "P");
            tempMap.put("\u0420", "R");
            tempMap.put("\u0421", "S");
            tempMap.put("\u0422", "T");
            tempMap.put("\u0423", "U");
            tempMap.put("\u0478", "U");
            tempMap.put("\u04af", "U");
            tempMap.put("\ua64a", "U");
            tempMap.put("\u0424", "F");
            tempMap.put("\u0425", "H");
            tempMap.put("\u0426", "C");
            tempMap.put("\u0427", "Ch");
            tempMap.put("\u0428", new String(new byte[]{0, -118}, ISO_8859_1));
            tempMap.put("\u0429", "Shch");
            tempMap.put("\u042a", new String(new byte[]{0, -108}, ISO_8859_1));
            tempMap.put("\u042b", "Y");
            tempMap.put("\u042c", new String(new byte[]{0, -110}, ISO_8859_1));
            tempMap.put("\u042d", new String(new byte[]{0, -56}, ISO_8859_1));
            tempMap.put("\u042e", new String(new byte[]{0, -37}, ISO_8859_1));
            tempMap.put("\u042f", new String(new byte[]{0, -62}, ISO_8859_1));
            tempMap.put("\u0430", "a");
            tempMap.put("\u0431", "b");
            tempMap.put("\u0432", "v");
            tempMap.put("\u0433", "g");
            tempMap.put("\u0434", "d");
            tempMap.put("\u0435", "e");
            tempMap.put("\u0436", new String(new byte[]{0, -98}, ISO_8859_1));
            tempMap.put("\u0437", "z");
            tempMap.put("\u0438", "i");
            tempMap.put("\u0439", "j");
            tempMap.put("\u043a", "k");
            tempMap.put("\u043b", "l");
            tempMap.put("\u043c", "m");
            tempMap.put("\u043d", "n");
            tempMap.put("\u043e", "o");
            tempMap.put("\u043f", "p");
            tempMap.put("\u0440", "r");
            tempMap.put("\u0441", "s");
            tempMap.put("\u0442", "t");
            tempMap.put("\u0443", "u");
            tempMap.put("\u0444", "f");
            tempMap.put("\u0445", "h");
            tempMap.put("\u0446", "c");
            tempMap.put("\u0447", "ch");
            tempMap.put("\u0448", new String(new byte[]{0, -102}, ISO_8859_1));
            tempMap.put("\u0449", "shch");
            tempMap.put("\u044a", new String(new byte[]{0, -108}, ISO_8859_1));
            tempMap.put("\u044b", "y");
            tempMap.put("\u044c", new String(new byte[]{0, -110}, ISO_8859_1));
            tempMap.put("\u044d", new String(new byte[]{0, -24}, ISO_8859_1));
            tempMap.put("\u044e", new String(new byte[]{0, -5}, ISO_8859_1));
            tempMap.put("\ua655", new String(new byte[]{0, -5}, ISO_8859_1));
            tempMap.put("\u044f", new String(new byte[]{0, -30}, ISO_8859_1));
            tempMap.put("\u0450", new String(new byte[]{0, -24}, ISO_8859_1));
            tempMap.put("\u0451", new String(new byte[]{0, -21}, ISO_8859_1));
            tempMap.put("\u0452", new String(new byte[]{0, -16}, ISO_8859_1));
            tempMap.put("\u0454", new String(new byte[]{0, -22}, ISO_8859_1));
            tempMap.put("\u0455", "s");
            tempMap.put("\u0456", new String(new byte[]{0, -20}, ISO_8859_1));
            tempMap.put("\u0457", new String(new byte[]{0, -17}, ISO_8859_1));
            tempMap.put("\u0490", "G");
            tempMap.put("\u0491", "g");
            tempMap.put("\u2013", new String(new byte[]{0, -106}, ISO_8859_1));
            tempMap.put("\u2014", new String(new byte[]{0, -105}, ISO_8859_1));
            tempMap.put("\u2018", new String(new byte[]{0, -111}, ISO_8859_1));
            tempMap.put("\u2019", new String(new byte[]{0, -110}, ISO_8859_1));
            tempMap.put("\u201a", new String(new byte[]{0, -126}, ISO_8859_1));
            tempMap.put("\u201c", new String(new byte[]{0, -109}, ISO_8859_1));
            tempMap.put("\u201d", new String(new byte[]{0, -108}, ISO_8859_1));
            tempMap.put("\u201e", new String(new byte[]{0, -124}, ISO_8859_1));
            tempMap.put("\u2020", new String(new byte[]{0, -122}, ISO_8859_1));
            tempMap.put("\u2021", new String(new byte[]{0, -121}, ISO_8859_1));
            tempMap.put(UNICODE_BULLET, new String(new byte[]{0, -107}, ISO_8859_1));
            tempMap.put("\u2026", new String(new byte[]{0, -123}, ISO_8859_1));
            tempMap.put("\u2030", new String(new byte[]{0, -119}, ISO_8859_1));
            tempMap.put("\u2039", new String(new byte[]{0, -117}, ISO_8859_1));
            tempMap.put("\u203a", new String(new byte[]{0, -101}, ISO_8859_1));
            tempMap.put("\u20ac", new String(new byte[]{0, -128}, ISO_8859_1));
            tempMap.put("\u2122", new String(new byte[]{0, -103}, ISO_8859_1));
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException("Problem creating translation table due to Unsupported Encoding (coding error)", uee);
        }
        utf16ToWinAnsi = Collections.unmodifiableMap(tempMap);
        nonAsciiPattern = Pattern.compile("[^\u0000-\u00ff]");
    }

    static class PageBuffer {
        public final int pageNum;
        private long lastOrd = 0L;
        private final Set<PdfItem> items = new TreeSet<PdfItem>();

        private PageBuffer(int pn) {
            this.pageNum = pn;
        }

        void fillRect(float xVal, float yVal, float w, float h, Color c, float z) {
            this.items.add(FillRect.of(xVal, yVal, w, h, c, this.lastOrd++, z));
        }

        void drawJpeg(float xVal, float yVal, ScaledJpeg sj, PdfLayoutMgr mgr) {
            this.items.add(DrawJpeg.of(xVal, yVal, sj, mgr, this.lastOrd++, 0.0f));
        }

        void drawPng(float xVal, float yVal, ScaledPng sj, PdfLayoutMgr mgr) {
            this.items.add(DrawPng.of(xVal, yVal, sj, mgr, this.lastOrd++, 0.0f));
        }

        private void drawLine(float xa, float ya, float xb, float yb, LineStyle ls, float z) {
            this.items.add(DrawLine.of(xa, ya, xb, yb, ls, this.lastOrd++, z));
        }

        void drawLine(float xa, float ya, float xb, float yb, LineStyle ls) {
            this.drawLine(xa, ya, xb, yb, ls, 0.0f);
        }

        private void drawStyledText(float xCoord, float yCoord, String text, TextStyle s, float z) {
            this.items.add(Text.of(xCoord, yCoord, text, s, this.lastOrd++, z));
        }

        void drawStyledText(float xCoord, float yCoord, String text, TextStyle s) {
            this.drawStyledText(xCoord, yCoord, text, s, 0.0f);
        }

        private void commit(PDPageContentStream stream) throws IOException {
            for (PdfItem item : this.items) {
                item.commit(stream);
            }
        }

        private static class DrawJpeg
        extends PdfItem {
            private final float x;
            private final float y;
            private final PDJpeg jpeg;
            private final ScaledJpeg scaledJpeg;

            private DrawJpeg(float xVal, float yVal, ScaledJpeg sj, PdfLayoutMgr mgr, long ord, float z) {
                super(ord, z);
                this.x = xVal;
                this.y = yVal;
                this.jpeg = mgr.ensureCached(sj);
                this.scaledJpeg = sj;
            }

            public static DrawJpeg of(float xVal, float yVal, ScaledJpeg sj, PdfLayoutMgr mgr, long ord, float z) {
                return new DrawJpeg(xVal, yVal, sj, mgr, ord, z);
            }

            public void commit(PDPageContentStream stream) throws IOException {
                XyDim dim = this.scaledJpeg.dimensions();
                stream.drawXObject((PDXObject)this.jpeg, this.x, this.y, dim.x(), dim.y());
            }
        }

        private static class DrawPng
        extends PdfItem {
            private final float x;
            private final float y;
            private final PDPixelMap png;
            private final ScaledPng scaledPng;

            private DrawPng(float xVal, float yVal, ScaledPng sj, PdfLayoutMgr mgr, long ord, float z) {
                super(ord, z);
                this.x = xVal;
                this.y = yVal;
                this.png = mgr.ensureCached(sj);
                this.scaledPng = sj;
            }

            public static DrawPng of(float xVal, float yVal, ScaledPng sj, PdfLayoutMgr mgr, long ord, float z) {
                return new DrawPng(xVal, yVal, sj, mgr, ord, z);
            }

            public void commit(PDPageContentStream stream) throws IOException {
                XyDim dim = this.scaledPng.dimensions();
                stream.drawXObject((PDXObject)this.png, this.x, this.y, dim.x(), dim.y());
            }
        }

        static class Text
        extends PdfItem {
            public final float x;
            public final float y;
            public final String t;
            public final TextStyle style;

            private Text(float xCoord, float yCoord, String text, TextStyle s, long ord, float z) {
                super(ord, z);
                this.x = xCoord;
                this.y = yCoord;
                this.t = text;
                this.style = s;
            }

            public static Text of(float xCoord, float yCoord, String text, TextStyle s, long ord, float z) {
                return new Text(xCoord, yCoord, text, s, ord, z);
            }

            public void commit(PDPageContentStream stream) throws IOException {
                stream.beginText();
                stream.setNonStrokingColor(this.style.textColor());
                stream.setFont((PDFont)this.style.font(), this.style.fontSize());
                stream.moveTextPositionByAmount(this.x, this.y);
                stream.drawString(this.t);
                stream.endText();
            }
        }

        private static class FillRect
        extends PdfItem {
            private final float x;
            private final float y;
            private final float width;
            private final float height;
            private final Color color;

            private FillRect(float xVal, float yVal, float w, float h, Color c, long ord, float z) {
                super(ord, z);
                this.x = xVal;
                this.y = yVal;
                this.width = w;
                this.height = h;
                this.color = c;
            }

            public static FillRect of(float xVal, float yVal, float w, float h, Color c, long ord, float z) {
                return new FillRect(xVal, yVal, w, h, c, ord, z);
            }

            public void commit(PDPageContentStream stream) throws IOException {
                stream.setNonStrokingColor(this.color);
                stream.fillRect(this.x, this.y, this.width, this.height);
            }
        }

        private static class DrawLine
        extends PdfItem {
            private final float x1;
            private final float y1;
            private final float x2;
            private final float y2;
            private final LineStyle style;

            private DrawLine(float xa, float ya, float xb, float yb, LineStyle s, long ord, float z) {
                super(ord, z);
                this.x1 = xa;
                this.y1 = ya;
                this.x2 = xb;
                this.y2 = yb;
                this.style = s;
            }

            public static DrawLine of(float xa, float ya, float xb, float yb, LineStyle s, long ord, float z) {
                return new DrawLine(xa, ya, xb, yb, s, ord, z);
            }

            public void commit(PDPageContentStream stream) throws IOException {
                stream.setStrokingColor(this.style.color());
                stream.setLineWidth(this.style.width());
                stream.drawLine(this.x1, this.y1, this.x2, this.y2);
            }
        }
    }
}

