/*
 * Decompiled with CFR 0.152.
 */
package com.planbase.pdf.layoutmanager;

import com.planbase.pdf.layoutmanager.LogicalPage;
import com.planbase.pdf.layoutmanager.Renderable;
import com.planbase.pdf.layoutmanager.XyDim;
import com.planbase.pdf.layoutmanager.XyOffset;
import java.awt.image.BufferedImage;

public class ScaledPng
implements Renderable {
    public static final float ASSUMED_IMAGE_DPI = 300.0f;
    public static final float IMAGE_SCALE = 0.24000001f;
    private final BufferedImage bufferedImage;
    private final float width;
    private final float height;

    private ScaledPng(BufferedImage bi, float w, float h) {
        if (w <= 0.0f) {
            w = (float)bi.getWidth() * 0.24000001f;
        }
        if (h <= 0.0f) {
            h = (float)bi.getHeight() * 0.24000001f;
        }
        this.bufferedImage = bi;
        this.width = w;
        this.height = h;
    }

    public static ScaledPng of(BufferedImage bi, float w, float h) {
        return new ScaledPng(bi, w, h);
    }

    public static ScaledPng of(BufferedImage bi) {
        return new ScaledPng(bi, 0.0f, 0.0f);
    }

    public BufferedImage bufferedImage() {
        return this.bufferedImage;
    }

    public XyDim dimensions() {
        return XyDim.of(this.width, this.height);
    }

    public XyDim calcDimensions(float maxWidth) {
        return this.dimensions();
    }

    public XyOffset render(LogicalPage lp, XyOffset outerTopLeft, XyDim outerDimensions, boolean allPages) {
        float y = outerTopLeft.y() - this.height;
        lp.drawPng(outerTopLeft.x(), y, this);
        return XyOffset.of(outerTopLeft.x() + this.width, y);
    }
}

