/*
 * Decompiled with CFR 0.152.
 */
package com.planbase.pdf.layoutmanager;

import com.planbase.pdf.layoutmanager.CellStyle;
import com.planbase.pdf.layoutmanager.LogicalPage;
import com.planbase.pdf.layoutmanager.Renderable;
import com.planbase.pdf.layoutmanager.TablePart;
import com.planbase.pdf.layoutmanager.TextStyle;
import com.planbase.pdf.layoutmanager.XyDim;
import com.planbase.pdf.layoutmanager.XyOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableBuilder
implements Renderable {
    private final LogicalPage logicalPage;
    private final XyOffset topLeft;
    private final List<Float> cellWidths = new ArrayList<Float>(1);
    private CellStyle cellStyle;
    private TextStyle textStyle;
    private final List<TablePart> parts = new ArrayList<TablePart>(2);

    private TableBuilder(LogicalPage lp, XyOffset tl) {
        this.logicalPage = lp;
        this.topLeft = tl;
    }

    public static TableBuilder of(LogicalPage lp, XyOffset tl) {
        return new TableBuilder(lp, tl);
    }

    public XyOffset topLeft() {
        return this.topLeft;
    }

    public List<Float> cellWidths() {
        return Collections.unmodifiableList(this.cellWidths);
    }

    public TableBuilder addCellWidths(List<Float> x) {
        this.cellWidths.addAll(x);
        return this;
    }

    public TableBuilder addCellWidths(float ... ws) {
        for (float w : ws) {
            this.cellWidths.add(Float.valueOf(w));
        }
        return this;
    }

    public TableBuilder addCellWidth(Float x) {
        this.cellWidths.add(x);
        return this;
    }

    public CellStyle cellStyle() {
        return this.cellStyle;
    }

    public TableBuilder cellStyle(CellStyle x) {
        this.cellStyle = x;
        return this;
    }

    public TextStyle textStyle() {
        return this.textStyle;
    }

    public TableBuilder textStyle(TextStyle x) {
        this.textStyle = x;
        return this;
    }

    public TableBuilder addPart(TablePart tp) {
        this.parts.add(tp);
        return this;
    }

    public TablePart partBuilder() {
        return TablePart.of(this);
    }

    public XyOffset buildTable() {
        return this.logicalPage.addTable(this);
    }

    @Override
    public XyDim calcDimensions(float maxWidth) {
        XyDim maxDim = XyDim.ZERO;
        for (TablePart part : this.parts) {
            XyDim wh = part.calcDimensions();
            maxDim = XyDim.of(Math.max(wh.x(), maxDim.x()), maxDim.y() + wh.y());
        }
        return maxDim;
    }

    @Override
    public XyOffset render(LogicalPage lp, XyOffset outerTopLeft, XyDim outerDimensions, boolean allPages) {
        XyOffset rightmostLowest = outerTopLeft;
        for (TablePart part : this.parts) {
            XyOffset rl = part.render(lp, XyOffset.of(outerTopLeft.x(), rightmostLowest.y()), allPages);
            rightmostLowest = XyOffset.of(Math.max(rl.x(), rightmostLowest.x()), Math.min(rl.y(), rightmostLowest.y()));
        }
        return rightmostLowest;
    }

    public String toString() {
        return "TableBuilder(" + System.identityHashCode(this) + ")";
    }
}

