/*
 * Decompiled with CFR 0.152.
 */
package com.planbase.pdf.layoutmanager;

import com.planbase.pdf.layoutmanager.CellStyle;
import com.planbase.pdf.layoutmanager.LogicalPage;
import com.planbase.pdf.layoutmanager.TableBuilder;
import com.planbase.pdf.layoutmanager.TableRowBuilder;
import com.planbase.pdf.layoutmanager.TextStyle;
import com.planbase.pdf.layoutmanager.XyDim;
import com.planbase.pdf.layoutmanager.XyOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TablePart {
    private final TableBuilder tableBuilder;
    private List<Float> cellWidths = new ArrayList<Float>();
    private CellStyle cellStyle;
    private TextStyle textStyle;
    private float minRowHeight = 0.0f;
    private final List<TableRowBuilder> rows = new ArrayList<TableRowBuilder>(1);

    private TablePart(TableBuilder t) {
        this.tableBuilder = t;
        this.cellWidths.addAll(t.cellWidths());
        this.cellStyle = t.cellStyle();
        this.textStyle = t.textStyle();
    }

    public static TablePart of(TableBuilder t) {
        return new TablePart(t);
    }

    public List<Float> cellWidths() {
        return Collections.unmodifiableList(this.cellWidths);
    }

    public float cellWidth(int i) {
        return this.cellWidths.get(i).floatValue();
    }

    public TablePart addCellWidths(float ... ws) {
        for (float w : ws) {
            this.cellWidths.add(Float.valueOf(w));
        }
        return this;
    }

    public TablePart addCellWidth(Float x) {
        this.cellWidths.add(x);
        return this;
    }

    public int numCellWidths() {
        return this.cellWidths.size();
    }

    public CellStyle cellStyle() {
        return this.cellStyle;
    }

    public TablePart cellStyle(CellStyle x) {
        this.cellStyle = x;
        return this;
    }

    public TablePart align(CellStyle.Align a) {
        this.cellStyle = this.cellStyle.align(a);
        return this;
    }

    public TextStyle textStyle() {
        return this.textStyle;
    }

    public TablePart textStyle(TextStyle x) {
        this.textStyle = x;
        return this;
    }

    public float minRowHeight() {
        return this.minRowHeight;
    }

    public TablePart minRowHeight(float f) {
        this.minRowHeight = f;
        return this;
    }

    public TableRowBuilder rowBuilder() {
        return TableRowBuilder.of(this);
    }

    public TablePart addRow(TableRowBuilder trb) {
        this.rows.add(trb);
        return this;
    }

    public TableBuilder buildPart() {
        return this.tableBuilder.addPart(this);
    }

    public XyDim calcDimensions() {
        XyDim maxDim = XyDim.ZERO;
        for (TableRowBuilder row : this.rows) {
            XyDim wh = row.calcDimensions();
            maxDim = XyDim.of(Math.max(wh.x(), maxDim.x()), maxDim.y() + wh.y());
        }
        return maxDim;
    }

    public XyOffset render(LogicalPage lp, XyOffset outerTopLeft, boolean allPages) {
        XyOffset rightmostLowest = outerTopLeft;
        for (TableRowBuilder row : this.rows) {
            XyOffset rl = row.render(lp, XyOffset.of(outerTopLeft.x(), rightmostLowest.y()), allPages);
            rightmostLowest = XyOffset.of(Math.max(rl.x(), rightmostLowest.x()), Math.min(rl.y(), rightmostLowest.y()));
        }
        return rightmostLowest;
    }

    public String toString() {
        return "TablePart(" + this.tableBuilder + " " + System.identityHashCode(this) + ")";
    }
}

