/*
 * Decompiled with CFR 0.152.
 */
package com.planbase.pdf.layoutmanager;

import com.planbase.pdf.layoutmanager.BorderStyle;
import com.planbase.pdf.layoutmanager.Cell;
import com.planbase.pdf.layoutmanager.CellBuilder;
import com.planbase.pdf.layoutmanager.CellStyle;
import com.planbase.pdf.layoutmanager.LogicalPage;
import com.planbase.pdf.layoutmanager.Renderable;
import com.planbase.pdf.layoutmanager.ScaledJpeg;
import com.planbase.pdf.layoutmanager.TablePart;
import com.planbase.pdf.layoutmanager.Text;
import com.planbase.pdf.layoutmanager.TextStyle;
import com.planbase.pdf.layoutmanager.XyDim;
import com.planbase.pdf.layoutmanager.XyOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TableRowBuilder {
    private final TablePart tablePart;
    private TextStyle textStyle;
    private CellStyle cellStyle;
    private final List<Cell> cells;
    private float minRowHeight = 0.0f;
    private int nextCellIdx = 0;

    private TableRowBuilder(TablePart tp) {
        this.tablePart = tp;
        this.cells = new ArrayList<Cell>(tp.cellWidths().size());
        this.textStyle = tp.textStyle();
        this.cellStyle = tp.cellStyle();
        this.minRowHeight = tp.minRowHeight();
    }

    public float nextCellSize() {
        if (this.tablePart.numCellWidths() <= this.nextCellIdx) {
            throw new IllegalStateException("Tried to add more cells than you set sizes for");
        }
        return this.tablePart.cellWidths().get(this.nextCellIdx).floatValue();
    }

    public static TableRowBuilder of(TablePart tp) {
        return new TableRowBuilder(tp);
    }

    public TextStyle textStyle() {
        return this.textStyle;
    }

    public TableRowBuilder textStyle(TextStyle x) {
        this.textStyle = x;
        return this;
    }

    public CellStyle cellStyle() {
        return this.cellStyle;
    }

    public TableRowBuilder addCells(Cell ... cs) {
        Collections.addAll(this.cells, cs);
        this.nextCellIdx += cs.length;
        return this;
    }

    public int nextCellIdx() {
        return this.nextCellIdx;
    }

    public TableRowBuilder addTextCells(String ... ss) {
        if (this.textStyle == null) {
            throw new IllegalStateException("Tried to add a text cell without setting a default text style");
        }
        for (String s : ss) {
            this.addCellAt(Cell.of(this.cellStyle, this.nextCellSize(), Text.of(this.textStyle, s)), this.nextCellIdx);
            ++this.nextCellIdx;
        }
        return this;
    }

    public TableRowBuilder addJpegCells(ScaledJpeg ... js) {
        for (ScaledJpeg j : js) {
            this.addCellAt(Cell.of(this.cellStyle, this.nextCellSize(), j), this.nextCellIdx);
            ++this.nextCellIdx;
        }
        return this;
    }

    public TableRowBuilder addCell(Cell c) {
        this.cells.add(c);
        ++this.nextCellIdx;
        return this;
    }

    public TableRowBuilder addCellAt(Cell c, int idx) {
        while (this.cells.size() < idx + 1) {
            this.cells.add(null);
        }
        if (this.cells.get(idx) != null) {
            throw new IllegalStateException("Tried to add a cell built from a table row back to the row after adding a free cell in its spot.");
        }
        this.cells.set(idx, c);
        return this;
    }

    public TableRowBuilder minRowHeight(float f) {
        this.minRowHeight = f;
        return this;
    }

    public RowCellBuilder cellBuilder() {
        RowCellBuilder cb = new RowCellBuilder(this);
        ++this.nextCellIdx;
        return cb;
    }

    public TablePart buildRow() {
        if (this.cells.contains(null)) {
            throw new IllegalStateException("Cannot build row when some TableRowCellBuilders have been created but the cells not built and added back to the row.");
        }
        return this.tablePart.addRow(this);
    }

    public XyDim calcDimensions() {
        XyDim maxDim = XyDim.ZERO;
        for (Cell cell : this.cells) {
            XyDim wh = cell.calcDimensions(cell.width());
            maxDim = XyDim.of(wh.x() + maxDim.x(), Math.max(maxDim.y(), wh.y()));
        }
        return maxDim;
    }

    public XyOffset render(LogicalPage lp, XyOffset outerTopLeft, boolean allPages) {
        XyDim maxDim = XyDim.ZERO.y(this.minRowHeight);
        for (Cell cell : this.cells) {
            XyDim wh = cell.calcDimensions(cell.width());
            maxDim = XyDim.of(maxDim.x() + cell.width(), Math.max(maxDim.y(), wh.y()));
        }
        float maxHeight = maxDim.y();
        float x = outerTopLeft.x();
        for (Cell cell : this.cells) {
            cell.render(lp, XyOffset.of(x, outerTopLeft.y()), XyDim.of(cell.width(), maxHeight), allPages);
            x += cell.width();
        }
        return XyOffset.of(x, outerTopLeft.y() - maxHeight);
    }

    public String toString() {
        return "TableRowBuilder(" + this.tablePart + " " + System.identityHashCode(this) + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RowCellBuilder
    implements CellBuilder {
        private final TableRowBuilder tableRowBuilder;
        private float width;
        private CellStyle cellStyle;
        private final List<Renderable> rows = new ArrayList<Renderable>();
        private TextStyle textStyle;
        private final int colIdx;

        private RowCellBuilder(TableRowBuilder trb) {
            this.tableRowBuilder = trb;
            this.width = trb.nextCellSize();
            this.cellStyle = trb.cellStyle();
            this.textStyle = trb.textStyle();
            this.colIdx = trb.nextCellIdx();
        }

        @Override
        public RowCellBuilder cellStyle(CellStyle cs) {
            this.cellStyle = cs;
            return this;
        }

        public RowCellBuilder borderStyle(BorderStyle bs) {
            this.cellStyle = this.cellStyle.borderStyle(bs);
            return this;
        }

        @Override
        public RowCellBuilder align(CellStyle.Align align) {
            this.cellStyle = this.cellStyle.align(align);
            return this;
        }

        @Override
        public RowCellBuilder textStyle(TextStyle x) {
            this.textStyle = x;
            return this;
        }

        @Override
        public RowCellBuilder add(Renderable ... rs) {
            Collections.addAll(this.rows, rs);
            return this;
        }

        @Override
        public RowCellBuilder add(List<Renderable> js) {
            if (js != null) {
                this.rows.addAll(js);
            }
            return this;
        }

        @Override
        public RowCellBuilder add(String ... ss) {
            if (this.textStyle == null) {
                throw new IllegalStateException("Must set a default text style before adding raw strings");
            }
            for (String s : ss) {
                this.rows.add(Text.of(this.textStyle, s));
            }
            return this;
        }

        @Override
        public RowCellBuilder add(TextStyle ts, List<String> ls) {
            if (ls != null) {
                for (String s : ls) {
                    this.rows.add(Text.of(ts, s));
                }
            }
            return this;
        }

        public TableRowBuilder buildCell() {
            Cell c = Cell.of(this.cellStyle, this.width, this.rows);
            return this.tableRowBuilder.addCellAt(c, this.colIdx);
        }

        public String toString() {
            return "RowCellBuilder(" + this.tableRowBuilder + " colIdx=" + this.colIdx + ")";
        }

        public int hashCode() {
            return this.tableRowBuilder.hashCode() + this.colIdx;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof RowCellBuilder) || this.hashCode() != other.hashCode()) {
                return false;
            }
            RowCellBuilder that = (RowCellBuilder)other;
            return this.colIdx == that.colIdx && this.tableRowBuilder.equals(that.tableRowBuilder);
        }
    }
}

