/*
 * Decompiled with CFR 0.152.
 */
package com.planbase.pdf.layoutmanager;

import com.planbase.pdf.layoutmanager.CellStyle;
import com.planbase.pdf.layoutmanager.LogicalPage;
import com.planbase.pdf.layoutmanager.Padding;
import com.planbase.pdf.layoutmanager.PdfLayoutMgr;
import com.planbase.pdf.layoutmanager.Renderable;
import com.planbase.pdf.layoutmanager.TextStyle;
import com.planbase.pdf.layoutmanager.XyDim;
import com.planbase.pdf.layoutmanager.XyOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Text
implements Renderable {
    private final TextStyle textStyle;
    private final String text;
    private final Map<Float, WrappedBlock> dims = new HashMap<Float, WrappedBlock>();
    private final CellStyle.Align align = CellStyle.DEFAULT_ALIGN;
    public static final Text DEFAULT = new Text(null, "");

    private Text(TextStyle s, String t) {
        this.textStyle = s;
        this.text = t;
    }

    public static Text of(TextStyle style, String text) {
        if (text == null) {
            text = "";
        }
        if ("".equals(text) && style == null) {
            return DEFAULT;
        }
        return new Text(style, text);
    }

    public String text() {
        return this.text;
    }

    public TextStyle style() {
        return this.textStyle;
    }

    public int avgCharsForWidth(float width) {
        return (int)(width * 1220.0f / this.textStyle.avgCharWidth());
    }

    public float maxWidth() {
        return this.textStyle.stringWidthInDocUnits(this.text.trim());
    }

    private XyDim calcDimensionsForReal(float maxWidth) {
        if (maxWidth < 0.0f) {
            throw new IllegalArgumentException("Can't meaningfully wrap text with a negative width: " + maxWidth);
        }
        WrappedBlock wb = new WrappedBlock();
        float x = 0.0f;
        float y = 0.0f;
        float maxX = x;
        Text txt = this;
        String row = PdfLayoutMgr.convertJavaStringToWinAnsi(txt.text());
        String text = Text.substrNoLeadingWhitespace(row, 0);
        int charWidthGuess = txt.avgCharsForWidth(maxWidth);
        while (text.length() > 0) {
            int idx = charWidthGuess;
            int textLen = text.length();
            if (idx > textLen) {
                idx = textLen;
            }
            String substr = text.substring(0, idx);
            float strWidth = this.textStyle.stringWidthInDocUnits(substr);
            while (strWidth < maxWidth && idx < textLen) {
                while (idx < textLen && Character.isWhitespace(text.charAt(idx))) {
                    ++idx;
                }
                while (idx < textLen && !Character.isWhitespace(text.charAt(idx))) {
                    ++idx;
                }
                substr = text.substring(0, idx);
                strWidth = this.textStyle.stringWidthInDocUnits(substr);
            }
            --idx;
            while (strWidth > maxWidth && idx > 0) {
                while (idx > -1 && !Character.isWhitespace(text.charAt(idx))) {
                    --idx;
                }
                while (idx > -1 && Character.isWhitespace(text.charAt(idx))) {
                    --idx;
                }
                if (idx < 1) break;
                substr = text.substring(0, idx + 1);
                strWidth = this.textStyle.stringWidthInDocUnits(substr);
            }
            wb.rows.add(WrappedRow.of(substr, strWidth, this.textStyle.lineHeight()));
            y -= this.textStyle.lineHeight();
            text = Text.substrNoLeadingWhitespace(text, substr.length());
            if (!(strWidth > maxX)) continue;
            maxX = strWidth;
        }
        wb.blockDim = XyDim.of(maxX, 0.0f - y);
        this.dims.put(Float.valueOf(maxWidth), wb);
        return wb.blockDim;
    }

    private WrappedBlock ensureWrappedBlock(float maxWidth) {
        WrappedBlock wb = this.dims.get(Float.valueOf(maxWidth));
        if (wb == null) {
            this.calcDimensionsForReal(maxWidth);
            wb = this.dims.get(Float.valueOf(maxWidth));
        }
        return wb;
    }

    public XyDim calcDimensions(float maxWidth) {
        return this.ensureWrappedBlock((float)maxWidth).blockDim;
    }

    public XyOffset render(LogicalPage lp, XyOffset outerTopLeft, XyDim outerDimensions, boolean allPages) {
        float maxWidth = outerDimensions.x();
        WrappedBlock wb = this.ensureWrappedBlock(maxWidth);
        float x = outerTopLeft.x();
        float y = outerTopLeft.y();
        Padding innerPadding = this.align.calcPadding(outerDimensions, wb.blockDim);
        if (innerPadding != null) {
            x += innerPadding.left();
        }
        for (WrappedRow wr : wb.rows) {
            y -= this.textStyle.ascent();
            if (allPages) {
                lp.borderStyledText(x, y, wr.string, this.textStyle);
            } else {
                lp.drawStyledText(x, y, wr.string, this.textStyle);
            }
            y -= this.textStyle.descent();
            y -= this.textStyle.leading();
        }
        return XyOffset.of(outerTopLeft.x() + wb.blockDim.x(), outerTopLeft.y() - wb.blockDim.y());
    }

    private static String substrNoLeadingWhitespace(String text, int startIdx) {
        while (startIdx < text.length() && Character.isWhitespace(text.charAt(startIdx))) {
            ++startIdx;
        }
        if (startIdx > 0) {
            return text.substring(startIdx);
        }
        return text;
    }

    public String toString() {
        return "Text(\"" + (this.text.length() > 25 ? this.text.substring(0, 22) + "..." : this.text) + "\")";
    }

    private static class WrappedBlock {
        List<WrappedRow> rows = new ArrayList<WrappedRow>();
        XyDim blockDim;

        private WrappedBlock() {
        }
    }

    private static class WrappedRow {
        String string;
        XyDim rowDim;

        private WrappedRow() {
        }

        public static WrappedRow of(String s, float x, float y) {
            WrappedRow wr = new WrappedRow();
            wr.string = s;
            wr.rowDim = XyDim.of(x, y);
            return wr;
        }
    }
}

