/*
 * Decompiled with CFR 0.152.
 */
package com.planbase.pdf.layoutmanager;

import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class TextStyle {
    private final PDType1Font font;
    private final Color textColor;
    private final float fontSize;
    private final float avgCharWidth;
    private final float factor;
    private final float ascent;
    private final float descent;
    private final float leading;

    private TextStyle(PDType1Font f, float sz, Color tc) {
        if (f == null) {
            throw new IllegalArgumentException("Font must not be null");
        }
        if (tc == null) {
            tc = Color.BLACK;
        }
        this.font = f;
        this.textColor = tc;
        this.fontSize = sz;
        this.factor = this.fontSize / 960.0f;
        PDFontDescriptor fontDescriptor = this.font.getFontDescriptor();
        float rawAscent = fontDescriptor.getAscent();
        float rawDescent = fontDescriptor.getDescent();
        this.ascent = rawAscent * this.factor;
        this.descent = rawDescent * -this.factor;
        this.leading = this.descent / 2.0f;
        float avgFontWidth = 500.0f;
        try {
            avgFontWidth = this.font.getAverageFontWidth();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.avgCharWidth = avgFontWidth * this.fontSize;
    }

    public static TextStyle of(PDType1Font f, float sz, Color tc) {
        return new TextStyle(f, sz, tc);
    }

    public float stringWidthInDocUnits(String text) {
        try {
            return this.font.getStringWidth(text) * this.factor;
        }
        catch (IOException ioe) {
            return (float)text.length() * this.avgCharWidth;
        }
    }

    public PDType1Font font() {
        return this.font;
    }

    public float fontSize() {
        return this.fontSize;
    }

    public Color textColor() {
        return this.textColor;
    }

    public TextStyle textColor(Color c) {
        return TextStyle.of(this.font, this.fontSize, c);
    }

    public float avgCharWidth() {
        return this.avgCharWidth;
    }

    public float ascent() {
        return this.ascent;
    }

    public float descent() {
        return this.descent;
    }

    public float leading() {
        return this.leading;
    }

    public float lineHeight() {
        return this.ascent + this.descent + this.leading;
    }
}

