/*
 * Decompiled with CFR 0.152.
 */
package com.planbase.pdf.layoutmanager;

import com.planbase.pdf.layoutmanager.Utils;

public class XyDim {
    public static final XyDim ZERO = new XyDim(0.0f, 0.0f){

        public int hashCode() {
            return 0;
        }
    };
    private final float x;
    private final float y;

    private XyDim(float xCoord, float yCoord) {
        if (xCoord < 0.0f || yCoord < 0.0f) {
            throw new IllegalArgumentException("Dimensions must be positive");
        }
        this.x = xCoord;
        this.y = yCoord;
    }

    public static XyDim of(float x, float y) {
        if (x == 0.0f && y == 0.0f) {
            return ZERO;
        }
        return new XyDim(x, y);
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public XyDim x(float newX) {
        return XyDim.of(newX, this.y);
    }

    public XyDim y(float newY) {
        return XyDim.of(this.x, newY);
    }

    public XyDim minus(XyDim that) {
        return XyDim.of(this.x - that.x(), this.y - that.y());
    }

    public XyDim plus(XyDim that) {
        return XyDim.of(this.x + that.x(), this.y + that.y());
    }

    public XyDim maxXandY(XyDim that) {
        if (this.x >= that.x() && this.y >= that.y()) {
            return this;
        }
        if (this.x <= that.x() && this.y <= that.y()) {
            return that;
        }
        return XyDim.of(this.x > that.x() ? this.x : that.x(), this.y > that.y() ? this.y : that.y());
    }

    public boolean lte(XyDim that) {
        return this.x <= that.x() && this.y <= that.y();
    }

    public String toString() {
        return "XyDim(" + this.x + " " + this.y + ")";
    }

    public int hashCode() {
        return Utils.floatHashCode(this.x) ^ Utils.floatHashCode(this.y);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof XyDim) || this.hashCode() != other.hashCode()) {
            return false;
        }
        XyDim that = (XyDim)other;
        return this.x == that.x() && this.y == that.y();
    }
}

